/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.Collections;
import java.util.List;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.utils.ValidationUtils;
import net.andreinc.mockneat.utils.file.FileManager;

public class Dicts
extends MockUnitBase {
    private final FileManager fm = FileManager.getInstance();

    public static Dicts dicts() {
        return MockNeat.threadLocal().dicts();
    }

    protected Dicts() {
    }

    public Dicts(MockNeat mockNeat) {
        super(mockNeat);
    }

    public MockUnitString type(DictType type) {
        ValidationUtils.notNull(type, "type");
        return () -> this.mockNeat.fromStrings(this.fm.getLines(type))::val;
    }

    public MockUnitString types(DictType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        return () -> {
            DictType type = this.mockNeat.from(types).val();
            return this.mockNeat.fromStrings(this.fm.getLines(type))::val;
        };
    }

    public List<String> data(DictType type) {
        ValidationUtils.notNull(type, "type");
        return Collections.unmodifiableList(this.fm.getLines(type));
    }
}

