/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.seq;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import net.andreinc.aleph.AlephFormatter;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitLong;
import net.andreinc.mockneat.utils.ValidationUtils;

public class LongSeq
implements MockUnitLong {
    private long increment = 1L;
    private long start = 0L;
    private boolean cycle = true;
    private long max = Long.MAX_VALUE;
    private long min = Long.MIN_VALUE;
    private AtomicLong internal;

    public static LongSeq longSeq() {
        return MockNeat.threadLocal().longSeq();
    }

    public LongSeq(long start, long increment, long max, long min, boolean cycle) {
        ValidationUtils.isTrue(min < max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", min, "max", max}).fmt(), new Object[0]);
        this.increment = increment;
        this.start = start;
        this.cycle = cycle;
        this.max = max;
        this.min = min;
        this.internal = new AtomicLong(start);
    }

    public LongSeq(long start, long increment) {
        ValidationUtils.isTrue(this.min < this.max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", this.min, "max", this.max}).fmt(), new Object[0]);
        this.start = start;
        this.increment = increment;
        this.internal = new AtomicLong(start);
    }

    public LongSeq(long increment) {
        ValidationUtils.isTrue(this.min < this.max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", this.min, "max", this.max}).fmt(), new Object[0]);
        this.increment = increment;
        this.internal = new AtomicLong(this.start);
    }

    public LongSeq() {
        ValidationUtils.isTrue(this.min < this.max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", this.min, "max", this.max}).fmt(), new Object[0]);
        this.internal = new AtomicLong(this.start);
    }

    public LongSeq start(long start) {
        this.start = start;
        this.internal = new AtomicLong(start);
        return this;
    }

    public LongSeq increment(long increment) {
        this.increment = increment;
        return this;
    }

    public LongSeq cycle(boolean cycle) {
        this.cycle = cycle;
        return this;
    }

    public LongSeq max(long max) {
        ValidationUtils.isTrue(this.min < max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", this.min, "max", max}).fmt(), new Object[0]);
        this.max = max;
        return this;
    }

    public LongSeq min(long min) {
        ValidationUtils.isTrue(min < this.max, AlephFormatter.str((String)"The min value '#{min}' should be lower than the maximum '#{max}' value of the sequence.").args(new Object[]{"min", min, "max", this.max}).fmt(), new Object[0]);
        this.min = min;
        return this;
    }

    private boolean nextValueOverflows() {
        return this.increment > 0L ? this.internal.get() > this.max : this.internal.get() < this.min;
    }

    protected void fail() {
        String fmt = AlephFormatter.str((String)"LongSeq overflow. Values are generated inside the interval: [#{min}, #{max}]. Cannot increment any further.").arg("min", (Object)this.min).arg("max", (Object)this.max).fmt();
        throw new IllegalStateException(fmt);
    }

    @Override
    public Supplier<Long> supplier() {
        return () -> {
            if (this.nextValueOverflows()) {
                if (this.cycle) {
                    this.internal.set(this.start);
                } else {
                    this.fail();
                }
            }
            return this.internal.getAndAdd(this.increment);
        };
    }
}

