/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockConstValue;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitDouble;
import net.andreinc.mockneat.abstraction.MockUnitValue;
import net.andreinc.mockneat.abstraction.MockValue;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Probabilities<T>
extends MockUnitBase
implements MockUnit<T> {
    private final List<Pair<BigDecimal, MockValue<T>>> probabilities = new ArrayList<Pair<BigDecimal, MockValue<T>>>();
    private final MockUnitDouble mud;
    private final Class<T> cls;

    public static <T> Probabilities<T> probabilities(Class<T> cls) {
        return MockNeat.threadLocal().probabilites(cls);
    }

    public Probabilities(MockNeat mockNeat, Class<T> cls) {
        super(mockNeat);
        this.mud = mockNeat.doubles().range(0.0, 1.0);
        this.cls = cls;
    }

    @Override
    public Supplier<T> supplier() {
        return this::getMock;
    }

    public Probabilities<T> add(Double prob, MockUnit<T> mock) {
        ValidationUtils.notNull(prob, "prob");
        ValidationUtils.isTrue(prob.compareTo(0.0) > 0, "Probability '#{prob}' should be bigger than '0.0'.", "prob", prob);
        BigDecimal probInternal = BigDecimal.valueOf(prob);
        BigDecimal lastVal = this.lastVal();
        BigDecimal toAdd = lastVal.add(probInternal);
        ValidationUtils.isTrue(toAdd.compareTo(BigDecimal.valueOf(1.0)) <= 0, "Probabilities sum cannot be bigger (>) than '1.0'.", new Object[0]);
        this.probabilities.add(Pair.of(toAdd, MockUnitValue.unit(mock)));
        return this;
    }

    public Probabilities<T> add(Double prob, T obj) {
        ValidationUtils.notNull(prob, "prob");
        ValidationUtils.isTrue(prob.compareTo(0.0) > 0, "Probability '#{prob}' should be bigger than '0.0'.", "prob", prob);
        BigDecimal probInternal = BigDecimal.valueOf(prob);
        BigDecimal lastVal = this.lastVal();
        BigDecimal toAdd = lastVal.add(probInternal);
        ValidationUtils.isTrue(toAdd.compareTo(BigDecimal.valueOf(1.0)) <= 0, "Probabilities sum cannot be bigger (>) than '1.0'.", new Object[0]);
        this.probabilities.add(Pair.of(toAdd, MockConstValue.constant(obj)));
        return this;
    }

    private BigDecimal lastVal() {
        return this.probabilities.isEmpty() ? BigDecimal.valueOf(0.0) : this.probabilities.get(this.probabilities.size() - 1).getFirst();
    }

    private T getMock() {
        ValidationUtils.isTrue(this.probabilities.get(this.probabilities.size() - 1).getFirst().compareTo(BigDecimal.valueOf(1.0)) == 0, "Probabilities sum must be exactly (=) 1.0 when generating values.", new Object[0]);
        BigDecimal rVal = this.mud.map(BigDecimal::valueOf).val();
        int i = 0;
        while (this.probabilities.get(i).getFirst().compareTo(rVal) < 0) {
            ++i;
        }
        return this.cls.cast(this.probabilities.get(i).getSecond().get());
    }
}

