/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.objects;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Filler<T>
extends MockUnitBase
implements MockUnit<T> {
    private final Supplier<T> supplier;
    final Map<BiConsumer, MockUnit> setters = new LinkedHashMap<BiConsumer, MockUnit>();

    public static <T> Filler<T> filler(Supplier<T> supplier) {
        return MockNeat.threadLocal().filler(supplier);
    }

    protected Filler(Supplier<T> supplier) {
        ValidationUtils.notNull(supplier, "supplier");
        this.supplier = supplier;
    }

    public Filler(MockNeat mockNeat, Supplier<T> supplier) {
        super(mockNeat);
        ValidationUtils.notNull(supplier, "supplier");
        this.supplier = supplier;
    }

    public <R> Filler<T> setter(BiConsumer<T, R> setter, MockUnit<R> mockUnit) {
        ValidationUtils.notNull(setter, "setter");
        ValidationUtils.notNull(mockUnit, "mockUnit");
        this.setters.put(setter, mockUnit);
        return this;
    }

    public <R> Filler<T> constant(BiConsumer<T, R> setter, R constant) {
        ValidationUtils.notNull(setter, "setter");
        ValidationUtils.notNull(constant, "constant");
        this.setters.put(setter, () -> () -> constant);
        return this;
    }

    @Override
    public Supplier<T> supplier() {
        return () -> {
            Object object = this.supplier.get();
            ValidationUtils.notNull(object, "supplier");
            this.setters.forEach((k, v) -> k.accept(object, v.val()));
            return object;
        };
    }
}

