/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.user;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.PassStrengthType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class Passwords
extends MockUnitBase
implements MockUnitString {
    public static Passwords passwords() {
        return MockNeat.threadLocal().passwords();
    }

    public Passwords(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        PassStrengthType passStrengthType = this.mockNeat.from(PassStrengthType.class).val();
        return () -> this.nextPassword(passStrengthType);
    }

    public MockUnitString type(PassStrengthType passStrengthType) {
        ValidationUtils.notNull(passStrengthType, "passStrengthType");
        Supplier<String> supplier = () -> this.nextPassword(passStrengthType);
        return () -> supplier;
    }

    public MockUnitString types(PassStrengthType ... types) {
        ValidationUtils.notEmptyOrNullValues(types, "types");
        Supplier<String> supplier = () -> {
            PassStrengthType passStrengthType = this.mockNeat.from(types).val();
            return (String)this.type(passStrengthType).get();
        };
        return () -> supplier;
    }

    public MockUnitString weak() {
        return this.type(PassStrengthType.WEAK);
    }

    public MockUnitString medium() {
        return this.type(PassStrengthType.MEDIUM);
    }

    public MockUnitString strong() {
        return this.type(PassStrengthType.STRONG);
    }

    private String nextPassword(PassStrengthType passStrengthType) {
        switch (passStrengthType) {
            case WEAK: {
                return this.nextWeakPassword();
            }
            case MEDIUM: {
                return this.nextMediumPassword();
            }
            case STRONG: {
                return this.nextStrongPassword();
            }
        }
        throw new IllegalArgumentException("Invalid PassStrengthType");
    }

    private String nextWeakPassword() {
        Integer minLength = PassStrengthType.WEAK.getLength().getLowerBound();
        Integer maxLength = PassStrengthType.WEAK.getLength().getUpperBound();
        DictType dictType = this.mockNeat.from(new DictType[]{DictType.EN_NOUN_2SYLL, DictType.EN_NOUN_1SYLL}).val();
        String noun = (String)this.mockNeat.dicts().type(dictType).val();
        if (noun.length() > maxLength) {
            noun = noun.substring(0, maxLength);
        }
        StringBuilder resultBuff = new StringBuilder(noun);
        if (noun.length() < minLength) {
            int diff = minLength - noun.length();
            while (diff-- > 0) {
                resultBuff.append(this.mockNeat.ints().range(0, 10).val());
            }
        }
        return resultBuff.toString();
    }

    private String nextMediumPassword() {
        Integer minLength = PassStrengthType.MEDIUM.getLength().getLowerBound();
        Integer maxLength = PassStrengthType.MEDIUM.getLength().getUpperBound();
        String noun = (String)this.mockNeat.dicts().type(DictType.EN_NOUN_3SYLL).val();
        if (noun.length() > maxLength) {
            noun = noun.substring(0, maxLength);
        }
        StringBuilder resultBuff = new StringBuilder(noun);
        if (noun.length() < minLength) {
            int diff = minLength - noun.length();
            while (diff-- > 0) {
                resultBuff.append(this.mockNeat.chars().digits().val());
            }
        }
        int randUpperCaseIdx = (Integer)this.mockNeat.ints().range(0, noun.length() - 1).val();
        char replChar = resultBuff.charAt(randUpperCaseIdx);
        resultBuff.setCharAt(randUpperCaseIdx, Character.toUpperCase(replChar));
        int randSpecialChrIdx = (Integer)this.mockNeat.ints().range(0, resultBuff.length()).val();
        char specialChar = this.mockNeat.from(Alphabets.SPECIAL_CHARACTERS).val().charValue();
        if (resultBuff.length() < maxLength) {
            resultBuff.insert(randSpecialChrIdx, specialChar);
        } else {
            resultBuff.setCharAt(randSpecialChrIdx, specialChar);
        }
        return resultBuff.toString();
    }

    private String nextStrongPassword() {
        Integer minLength = PassStrengthType.STRONG.getLength().getLowerBound();
        Integer maxLength = PassStrengthType.STRONG.getLength().getUpperBound();
        int passLength = (Integer)this.mockNeat.ints().range(minLength, maxLength).val();
        StringBuilder buff = new StringBuilder();
        List<List> lists = Arrays.asList(Alphabets.SPECIAL_CHARACTERS, Alphabets.DIGITS, Alphabets.LETTERS);
        while (passLength-- > 1) {
            List cAlph = this.mockNeat.from(lists).val();
            buff.append(this.mockNeat.from(cAlph).val());
        }
        int randSpecialChrIdx = (Integer)this.mockNeat.ints().range(0, buff.length()).val();
        buff.insert(randSpecialChrIdx, this.mockNeat.from(Alphabets.SPECIAL_CHARACTERS).val());
        return buff.toString();
    }
}

