/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockConstValue;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitValue;
import net.andreinc.mockneat.abstraction.MockValue;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.unit.text.sql.SQLInsert;
import net.andreinc.mockneat.unit.text.sql.SQLTable;
import net.andreinc.mockneat.utils.ValidationUtils;

public class SQLInserts
extends MockUnitBase
implements MockUnit<SQLInsert> {
    private String tableName = "some_table";
    private final Map<String, Pair<MockValue<?>, Function<String, String>>> columns = new LinkedHashMap();

    public static SQLInserts sqlInserts() {
        return MockNeat.threadLocal().sqlInserts();
    }

    protected SQLInserts() {
    }

    public SQLInserts(MockNeat mockNeat) {
        super(mockNeat);
    }

    public SQLInserts tableName(String tableName) {
        ValidationUtils.notEmpty(tableName, "tableName");
        this.tableName = tableName;
        return this;
    }

    public SQLInserts column(String column, MockUnit<?> mockUnit) {
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.notNull(mockUnit, "mockUnit");
        this.columns.put(column, Pair.of(MockUnitValue.unit(mockUnit.mapToString()), null));
        return this;
    }

    public SQLInserts column(String column, MockUnit<?> mockUnit, Function<String, String> sqlFormatter) {
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.notNull(mockUnit, "mockUnit");
        ValidationUtils.notNull(sqlFormatter, "sqlFormatter");
        this.columns.put(column, Pair.of(MockUnitValue.unit(mockUnit.mapToString()), sqlFormatter));
        return this;
    }

    public SQLInserts column(String column, String str) {
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.notNull(str, "str");
        this.columns.put(column, Pair.of(MockConstValue.constant(str), null));
        return this;
    }

    public SQLInserts column(String column, String str, Function<String, String> sqlFormatter) {
        ValidationUtils.notEmpty(column, "column");
        ValidationUtils.notNull(str, "str");
        ValidationUtils.notNull(sqlFormatter, "sqlFormatter");
        this.columns.put(column, Pair.of(MockConstValue.constant(str), sqlFormatter));
        return this;
    }

    @Override
    public Supplier<SQLInsert> supplier() {
        return () -> {
            LinkedHashMap<String, Pair<String, Function<String, String>>> values = new LinkedHashMap<String, Pair<String, Function<String, String>>>();
            this.columns.forEach((k, v) -> values.put((String)k, (Pair<String, Function<String, String>>)Pair.of(((MockValue)v.getFirst()).getStr(), (Function)v.getSecond())));
            return new SQLInsert(this.tableName, values);
        };
    }

    public MockUnit<SQLTable> table(int numRows) {
        Supplier<SQLTable> supp = () -> {
            List<SQLInsert> inserts = this.list(numRows).val();
            return new SQLTable(this.mockNeat, inserts);
        };
        return () -> supp;
    }
}

