/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.hashes;

import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import org.apache.commons.codec.digest.DigestUtils;

public class Hashes
extends MockUnitBase {
    private static final Integer HASHED_STRING_SIZE = 128;

    public static Hashes hashes() {
        return MockNeat.threadLocal().hashes();
    }

    protected Hashes() {
    }

    public Hashes(MockNeat mockNeat) {
        super(mockNeat);
    }

    private Supplier<String> supplier(UnaryOperator<String> digester) {
        return this.mockNeat.strings().size(HASHED_STRING_SIZE).map(digester).supplier();
    }

    public MockUnitString md2() {
        return () -> this.supplier(DigestUtils::md2Hex);
    }

    public MockUnitString md5() {
        return () -> this.supplier(DigestUtils::md5Hex);
    }

    public MockUnitString sha1() {
        return () -> this.supplier(DigestUtils::sha1Hex);
    }

    public MockUnitString sha256() {
        return () -> this.supplier(DigestUtils::sha256Hex);
    }

    public MockUnitString sha384() {
        return () -> this.supplier(DigestUtils::sha384Hex);
    }

    public MockUnitString sha512() {
        return () -> this.supplier(DigestUtils::sha512Hex);
    }
}

