/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.financial;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.abstraction.MockUnitBase;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.types.enums.CharsType;
import net.andreinc.mockneat.types.enums.IBANType;
import net.andreinc.mockneat.utils.ValidationUtils;

public class IBANs
extends MockUnitBase
implements MockUnitString {
    private static final Map<Character, String> VALUE_MAP = new ConcurrentHashMap<Character, String>();

    public static IBANs ibans() {
        return MockNeat.threadLocal().ibans();
    }

    protected IBANs() {
    }

    public IBANs(MockNeat mockNeat) {
        super(mockNeat);
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            IBANType type = this.mockNeat.from(IBANType.class).val();
            return this.generate(type);
        };
    }

    public MockUnitString type(IBANType ibanType) {
        ValidationUtils.notNull(ibanType, "ibanType");
        return () -> () -> this.generate(ibanType);
    }

    public MockUnitString types(IBANType ... ibanTypes) {
        ValidationUtils.notEmpty(ibanTypes, "ibanTypes");
        return () -> () -> {
            IBANType type = this.mockNeat.from(ibanTypes).val();
            return this.generate(type);
        };
    }

    private String generate(IBANType ibanType) {
        List<Pair<Integer, CharsType>> bbanGroup = ibanType.getBban();
        String prefix = ibanType.getPrefix();
        StringBuilder iban = new StringBuilder(ibanType.getLength());
        StringBuilder bban = new StringBuilder(ibanType.getLength() - 4);
        StringBuilder numeric = new StringBuilder(ibanType.getLength() * 2);
        iban.append(prefix);
        bbanGroup.forEach(pair -> {
            int groupLength = (Integer)pair.getFirst();
            CharsType type = (CharsType)((Object)((Object)pair.getSecond()));
            while (groupLength-- > 0) {
                Character currentChar = this.mockNeat.chars().type(type).val();
                bban.append(currentChar);
                numeric.append(VALUE_MAP.get(currentChar));
            }
        });
        numeric.append(VALUE_MAP.get(Character.valueOf(prefix.charAt(0)))).append(VALUE_MAP.get(Character.valueOf(prefix.charAt(1)))).append("00");
        return iban.append(this.checkDigits(numeric.toString())).append((CharSequence)bban).toString();
    }

    public String checkDigits(String numericIBAN) {
        BigInteger bigInteger = new BigInteger(numericIBAN);
        int remainder = bigInteger.mod(BigInteger.valueOf(97L)).intValue();
        int checkDigits = 98 - remainder;
        return checkDigits < 10 ? "0" + checkDigits : String.valueOf(checkDigits);
    }

    static {
        IntStream.range(0, Alphabets.LETTERS_UPPERCASE.size()).forEach(i -> {
            Character upper = Alphabets.LETTERS_UPPERCASE.get(i);
            Character lower = Character.valueOf(Character.toLowerCase(upper.charValue()));
            String value = BigInteger.valueOf((long)i + 10L).toString();
            VALUE_MAP.put(lower, value);
            VALUE_MAP.put(upper, value);
        });
        IntStream.range(0, Alphabets.DIGITS.size()).forEach(i -> VALUE_MAP.put(Alphabets.DIGITS.get(i), Alphabets.DIGITS.get(i).toString()));
    }
}

