/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.abstraction;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import net.andreinc.mockneat.abstraction.MockUnit;
import net.andreinc.mockneat.abstraction.MockUnitString;
import net.andreinc.mockneat.utils.DateUtils;
import net.andreinc.mockneat.utils.MockUnitUtils;
import net.andreinc.mockneat.utils.ValidationUtils;

public interface MockUnitLocalDate
extends MockUnit<LocalDate> {
    @Deprecated
    default public MockUnit<Date> toUtilDate() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), localDate -> Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant()));
    }

    default public MockUnit<Date> mapToDate() {
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), DateUtils::convertToDateViaInstant);
    }

    default public MockUnitString display(String format) {
        return this.display(format, Locale.getDefault());
    }

    default public MockUnitString display(String format, Locale locale) {
        ValidationUtils.notNull(format, "format");
        ValidationUtils.notNull(locale, "locale");
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format, locale);
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), localDate -> localDate.format(dtf));
    }

    @Deprecated
    default public MockUnitString display(DateTimeFormatter dtf, Locale locale) {
        ValidationUtils.notNull(dtf, "dtf");
        ValidationUtils.notNull(locale, "locale");
        return () -> MockUnitUtils.ifSupplierNotNullDo(this.supplier(), dtf::format);
    }

    @Deprecated
    default public MockUnitString display(DateTimeFormatter dtf) {
        return this.display(dtf, Locale.getDefault());
    }
}

