/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.utils;

import java.util.Map;

public class NamedFormatUtils {
    public static String format(String fmt, Map<String, String> args) {
        State state = State.FREE_TEXT;
        StringBuilder result = new StringBuilder(fmt.length());
        StringBuilder param = new StringBuilder(16);
        block6: for (int i = 0; i < fmt.length(); ++i) {
            char chr = fmt.charAt(i);
            state = NamedFormatUtils.nextState(state, fmt, i);
            switch (state) {
                case FREE_TEXT: {
                    result.append(chr);
                    continue block6;
                }
                case PARAM_START: {
                    ++i;
                    continue block6;
                }
                case PARAM: {
                    param.append(chr);
                    continue block6;
                }
                case PARAM_END: {
                    NamedFormatUtils.appendParamValue(args, param, result);
                }
            }
        }
        return result.toString();
    }

    private static void appendParamValue(Map<String, String> args, StringBuilder param, StringBuilder result) {
        String paramStr = param.toString();
        NamedFormatUtils.validateParamLength(paramStr);
        NamedFormatUtils.validateParamExistence(args, paramStr);
        result.append(args.get(paramStr));
        param.setLength(0);
    }

    private static void validateParamLength(String paramStr) {
        if (0 == paramStr.length()) {
            throw new IllegalArgumentException("Named param should have a length!=0.");
        }
    }

    private static void validateParamExistence(Map<String, String> args, String paramStr) {
        if (!args.containsKey(paramStr)) {
            String fmt = String.format("Cannot find param: '%s' in the map of arguments.", paramStr);
            throw new IllegalArgumentException(fmt);
        }
    }

    private static State nextState(State currentState, String fmt, int idx) {
        switch (currentState) {
            case FREE_TEXT: {
                return NamedFormatUtils.isParamStart(fmt, idx) ? State.PARAM_START : State.FREE_TEXT;
            }
            case PARAM_START: {
                return State.PARAM;
            }
            case PARAM: {
                return NamedFormatUtils.isParamEnd(fmt, idx) ? State.PARAM_END : State.PARAM;
            }
            case PARAM_END: {
                return NamedFormatUtils.isParamStart(fmt, idx) ? State.PARAM_START : State.FREE_TEXT;
            }
        }
        throw new IllegalArgumentException("Invalid state Exception");
    }

    private static boolean isParamStart(String fmt, int idx) {
        return '#' == fmt.charAt(idx) && idx + 1 < fmt.length() && '{' == fmt.charAt(idx + 1);
    }

    private static boolean isParamEnd(String fmt, int idx) {
        return '}' == fmt.charAt(idx);
    }

    protected static enum State {
        PARAM,
        PARAM_START,
        PARAM_END,
        FREE_TEXT;

    }
}

