/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.andreinc.mockneat.interfaces.MockUnit;

public class MockUnitUtils {
    private MockUnitUtils() {
    }

    public static <T> void add(Class<? extends Collection> collectionClass, Collection<T> result, Supplier<T> supplier) {
        T value = supplier.get();
        try {
            result.add(value);
        }
        catch (Exception e) {
            String msg = String.format("Cannot add value '%s' to Collection('%s')", value, collectionClass.getSimpleName());
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T> void add(Class<? extends List> listClass, List<T> result, Supplier<T> supplier) {
        T value = supplier.get();
        try {
            result.add(value);
        }
        catch (Exception e) {
            String msg = String.format("Cannot add value '%s' to List('%s')", value, listClass.getSimpleName());
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T> void add(Class<? extends Set> setClass, Set<T> result, Supplier<T> supplier) {
        T value = supplier.get();
        try {
            result.add(value);
        }
        catch (Exception e) {
            String msg = String.format("Cannot add value '%s' to Set('%s')", value, setClass.getSimpleName());
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T, R> void put(Class<? extends Map> mapClass, Map<T, R> map, Supplier<T> keySupplier, Supplier<R> valueSupplier) {
        T keyVal = keySupplier.get();
        R valVal = valueSupplier.get();
        try {
            map.put(keyVal, valVal);
        }
        catch (Exception e) {
            String msg = String.format("Cannot put values {'%s' : '%s'} to Map('%s')", keyVal, valVal, mapClass.getSimpleName());
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static <T, R> void put(Class<? extends Map> mapClass, Map<T, R> map, T key, R value) {
        try {
            map.put(key, value);
        }
        catch (Exception e) {
            String msg = String.format("Cannot put values {'%s' : '%s'} to Map('%s')", key, value, mapClass.getSimpleName());
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static Object mockOrObject(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof MockUnit) {
            return ((MockUnit)obj).val();
        }
        return obj;
    }

    public static String listTypes(Object[] objs) {
        StringBuilder buff = new StringBuilder("(");
        Arrays.stream(objs).forEach(obj -> {
            if (null != obj) {
                buff.append(obj.getClass().getName());
            } else {
                buff.append("null");
            }
            buff.append(",");
        });
        buff.deleteCharAt(buff.length() - 1);
        buff.append(")");
        return buff.toString();
    }
}

