/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.user;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.StringFormatType;
import net.andreinc.mockneat.types.enums.UserNameType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Users
implements MockUnitString {
    private static final Double UNDERSCORE = 0.15;
    private final MockNeat mock;

    public Users(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<String> supplier() {
        return this.types(UserNameType.values()).supplier();
    }

    public MockUnitString type(UserNameType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        Supplier<String> supplier = () -> this.generateUserName(type);
        return () -> supplier;
    }

    public MockUnitString types(UserNameType ... types) {
        ValidationUtils.notEmptyTypes(types);
        UserNameType type = this.mock.from(types).val();
        return this.type(type);
    }

    private String generateUserName(UserNameType type) {
        Pair<DictType, DictType> pair = this.mock.from(type.getDictCombos()).val();
        String part1 = (String)this.mock.dicts().type(pair.getFirst()).format(StringFormatType.LOWER_CASE).val();
        String part2 = (String)this.mock.dicts().type(pair.getSecond()).format(StringFormatType.LOWER_CASE).val();
        if (this.mock.bools().probability(UNDERSCORE).val().booleanValue()) {
            part1 = part1 + "_";
        }
        return part1 + part2;
    }
}

