/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.user;

import java.util.List;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.PassStrengthType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Passwords
implements MockUnitString {
    private final MockNeat mock;

    public Passwords(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<String> supplier() {
        PassStrengthType passStrengthType = this.mock.from(PassStrengthType.class).val();
        return () -> this.nextPassword(passStrengthType);
    }

    public MockUnitString type(PassStrengthType passStrengthType) {
        Validate.notNull((Object)((Object)passStrengthType), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"passStrengthType"});
        Supplier<String> supplier = () -> this.nextPassword(passStrengthType);
        return () -> supplier;
    }

    public MockUnitString types(PassStrengthType ... types) {
        ValidationUtils.notEmptyTypes(types);
        PassStrengthType passStrengthType = this.mock.from(types).val();
        return this.type(passStrengthType);
    }

    private String nextPassword(PassStrengthType passStrengthType) {
        switch (passStrengthType) {
            case WEAK: {
                return this.nextWeakPassword();
            }
            case MEDIUM: {
                return this.nextMediumPassword();
            }
            case STRONG: {
                return this.nextStrongPassword();
            }
        }
        return "123456";
    }

    private String nextWeakPassword() {
        Integer minLength = PassStrengthType.WEAK.getLength().getLowerBound();
        Integer maxLength = PassStrengthType.WEAK.getLength().getUpperBound();
        DictType dictType = this.mock.from(new DictType[]{DictType.EN_NOUN_2SYLL, DictType.EN_NOUN_1SYLL}).val();
        String noun = (String)this.mock.dicts().type(dictType).val();
        if (noun.length() > maxLength) {
            noun = noun.substring(0, maxLength);
        }
        StringBuilder resultBuff = new StringBuilder(noun);
        if (noun.length() < minLength) {
            int diff = minLength - noun.length();
            while (diff-- > 0) {
                resultBuff.append(this.mock.ints().range(0, 10).val());
            }
        }
        return resultBuff.toString();
    }

    private String nextMediumPassword() {
        Integer minLength = PassStrengthType.MEDIUM.getLength().getLowerBound();
        Integer maxLength = PassStrengthType.MEDIUM.getLength().getUpperBound();
        String noun = (String)this.mock.dicts().type(DictType.EN_NOUN_3SYLL).val();
        if (noun.length() > maxLength) {
            noun = noun.substring(0, maxLength);
        }
        StringBuilder resultBuff = new StringBuilder(noun);
        if (noun.length() < minLength) {
            int diff = minLength - noun.length();
            while (diff-- > 0) {
                resultBuff.append(this.mock.chars().digits().val());
            }
        }
        int randUpperCaseIdx = (Integer)this.mock.ints().range(0, noun.length() - 1).val();
        char replChar = resultBuff.charAt(randUpperCaseIdx);
        resultBuff.setCharAt(randUpperCaseIdx, Character.toUpperCase(replChar));
        int randSpecialChrIdx = (Integer)this.mock.ints().range(0, resultBuff.length()).val();
        char specialChar = this.mock.from(Alphabets.SPECIAL_CHARACTERS).val().charValue();
        if (resultBuff.length() < maxLength) {
            resultBuff.insert(randSpecialChrIdx, specialChar);
        } else {
            resultBuff.setCharAt(randSpecialChrIdx, specialChar);
        }
        return resultBuff.toString();
    }

    private String nextStrongPassword() {
        Integer minLength = PassStrengthType.STRONG.getLength().getLowerBound();
        Integer maxLength = PassStrengthType.STRONG.getLength().getUpperBound();
        int passLength = (Integer)this.mock.ints().range(minLength, maxLength).val();
        StringBuilder buff = new StringBuilder();
        while (passLength-- > 1) {
            List cAlph = this.mock.from(new List[]{Alphabets.SPECIAL_CHARACTERS, Alphabets.DIGITS, Alphabets.LETTERS}).val();
            buff.append(this.mock.from(cAlph).val());
        }
        int randSpecialChrIdx = (Integer)this.mock.ints().range(0, buff.length()).val();
        buff.insert(randSpecialChrIdx, this.mock.from(Alphabets.SPECIAL_CHARACTERS).val());
        return buff.toString();
    }
}

