/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitLong;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Longs
implements MockUnitLong {
    private final MockNeat mock;
    private final Random random;

    public Longs(MockNeat mock) {
        this.mock = mock;
        this.random = mock.getRandom();
    }

    @Override
    public Supplier<Long> supplier() {
        return this.random::nextLong;
    }

    public MockUnitLong bound(long bound) {
        Validate.isTrue((bound >= 0L ? 1 : 0) != 0, (String)"The input parameter 'lowerBound' should be >= 0.0.", (Object[])new Object[0]);
        Supplier<Long> supplier = () -> {
            long result;
            long b;
            while ((b = this.random.nextLong() << 1 >>> 1) - (result = b % bound) + bound - 1L < 0L) {
            }
            return result;
        };
        return () -> supplier;
    }

    public MockUnitLong range(long lowerBound, long upperBound) {
        Validate.notNull((Object)lowerBound, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lowerBound"});
        Validate.notNull((Object)upperBound, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upperBound"});
        Validate.isTrue((lowerBound >= 0L ? 1 : 0) != 0, (String)"The input parameter 'lowerBound' should be >= 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > 0L ? 1 : 0) != 0, (String)"The input parameter 'upperBound' should be > 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > lowerBound ? 1 : 0) != 0, (String)"The input parameter 'upperBound' > 'lowerBound'.", (Object[])new Object[0]);
        Supplier<Long> supplier = () -> (Long)this.mock.longs().bound(upperBound - lowerBound).val() + lowerBound;
        return () -> supplier;
    }

    public MockUnitLong from(long[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "Input parameter: '%s' should not be NULL or empty.", new Object[]{"alphabet"});
        Supplier<Long> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }
}

