/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitInt;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Ints
implements MockUnitInt {
    private final Random random;

    public Ints(MockNeat mock) {
        this.random = mock.getRandom();
    }

    @Override
    public Supplier<Integer> supplier() {
        return this.random::nextInt;
    }

    public MockUnitInt bound(int bound) {
        Validate.isTrue((bound >= 0 ? 1 : 0) != 0, (String)"The input parameter 'lowerBound' should be >= 0.0.", (Object[])new Object[0]);
        Supplier<Integer> supp = () -> this.random.nextInt(bound);
        return () -> supp;
    }

    public MockUnitInt range(int lowerBound, int upperBound) {
        Validate.notNull((Object)lowerBound, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lowerBound"});
        Validate.notNull((Object)upperBound, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upperBound"});
        Validate.isTrue((lowerBound >= 0 ? 1 : 0) != 0, (String)"The input parameter 'lowerBound' should be >= 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > 0 ? 1 : 0) != 0, (String)"The input parameter 'upperBound' should be > 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > lowerBound ? 1 : 0) != 0, (String)"The input parameter 'upperBound' > 'lowerBound'.", (Object[])new Object[0]);
        Supplier<Integer> supp = () -> this.random.nextInt(upperBound - lowerBound) + lowerBound;
        return () -> supp;
    }

    public MockUnitInt from(int[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "Input parameter: '%s' should not be NULL or empty.", new Object[]{"alphabet"});
        Supplier<Integer> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }
}

