/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Floats
implements MockUnit<Float> {
    private final Random random;

    public Floats(MockNeat mock) {
        this.random = mock.getRandom();
    }

    @Override
    public Supplier<Float> supplier() {
        return this.random::nextFloat;
    }

    public MockUnit<Float> range(float lowerBound, float upperBound) {
        Validate.notNull((Object)Float.valueOf(lowerBound), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lowerBound"});
        Validate.notNull((Object)Float.valueOf(upperBound), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upperBound"});
        Validate.finite((double)lowerBound);
        Validate.finite((double)upperBound);
        Validate.notNaN((double)lowerBound);
        Validate.notNaN((double)upperBound);
        Validate.isTrue((lowerBound >= 0.0f ? 1 : 0) != 0, (String)"The input parameter 'lowerBound' should be >= 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > 0.0f ? 1 : 0) != 0, (String)"The input parameter 'upperBound' should be > 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > lowerBound ? 1 : 0) != 0, (String)"The input parameter 'upperBound' > 'lowerBound'.", (Object[])new Object[0]);
        Supplier<Float> supp = () -> Float.valueOf(this.random.nextFloat() * (upperBound - lowerBound) + lowerBound);
        return () -> supp;
    }

    public MockUnit<Float> bound(float bound) {
        return this.range(0.0f, bound);
    }

    public MockUnit<Float> from(float[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "Input parameter: '%s' should not be NULL or empty.", new Object[]{"alphabet"});
        Supplier<Float> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return Float.valueOf(alphabet[idx]);
        };
        return () -> supp;
    }
}

