/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitDouble;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Doubles
implements MockUnitDouble {
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private final Random random;

    public Doubles(MockNeat mock) {
        this.random = mock.getRandom();
    }

    @Override
    public Supplier<Double> supplier() {
        return this.random::nextDouble;
    }

    public MockUnitDouble gaussians() {
        return () -> this.random::nextGaussian;
    }

    public MockUnitDouble range(double lowerBound, double upperBound) {
        Validate.notNull((Object)lowerBound, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lowerBound"});
        Validate.notNull((Object)upperBound, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upperBound"});
        Validate.finite((double)lowerBound);
        Validate.finite((double)upperBound);
        Validate.notNaN((double)lowerBound);
        Validate.notNaN((double)upperBound);
        Validate.isTrue((lowerBound >= 0.0 ? 1 : 0) != 0, (String)"The input parameter 'lowerBound' should be >= 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > 0.0 ? 1 : 0) != 0, (String)"The input parameter 'upperBound' should be > 0.0.", (Object[])new Object[0]);
        Validate.isTrue((upperBound > lowerBound ? 1 : 0) != 0, (String)"The input parameter 'upperBound' > 'lowerBound'.", (Object[])new Object[0]);
        Supplier<Double> supp = () -> {
            double result = (double)(this.random.nextLong() >>> 11) * (double)1.110223E-16f;
            if (lowerBound < upperBound && (result = result * (upperBound - lowerBound) + lowerBound) >= upperBound) {
                result = Double.longBitsToDouble(Double.doubleToLongBits(upperBound) - 1L);
            }
            return result;
        };
        return () -> supp;
    }

    public MockUnitDouble bound(double bound) {
        return this.range(0.0, bound);
    }

    public MockUnitDouble from(double[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "Input parameter: '%s' should not be NULL or empty.", "alphabet");
        Supplier<Double> supp = () -> {
            int idx = this.random.nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }
}

