/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.types;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.alphabets.Alphabets;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.types.enums.CharsType;
import net.andreinc.mockneat.utils.ValidationUtils;
import org.apache.commons.lang3.Validate;

public class Chars
implements MockUnit<Character> {
    private final MockNeat mock;

    public Chars(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<Character> supplier() {
        return this.mock.from(Alphabets.ALPHA_NUMERIC)::val;
    }

    public MockUnit<Character> digits() {
        return this.mock.from(Alphabets.DIGITS);
    }

    public MockUnit<Character> lowerLetters() {
        return this.mock.from(Alphabets.LETTERS_LOWERCASE);
    }

    public MockUnit<Character> upperLetters() {
        return this.mock.from(Alphabets.LETTERS_UPPERCASE);
    }

    public MockUnit<Character> letters() {
        return this.mock.from(Alphabets.LETTERS);
    }

    public MockUnit<Character> hex() {
        return this.mock.from(Alphabets.HEXA);
    }

    public MockUnit<Character> type(CharsType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"type"});
        switch (type) {
            case DIGITS: {
                return this.digits();
            }
            case HEX: {
                return this.hex();
            }
            case LOWER_LETTERS: {
                return this.lowerLetters();
            }
            case UPPER_LETTERS: {
                return this.upperLetters();
            }
            case LETTERS: {
                return this.letters();
            }
        }
        throw new IllegalArgumentException("Invalid CharsType");
    }

    public MockUnit<Character> types(CharsType ... types) {
        Validate.notEmpty((Object[])types, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"types"});
        CharsType type = this.mock.from(types).val();
        return this.type(type);
    }

    public MockUnit<Character> from(String alphabet) {
        Validate.notEmpty((CharSequence)alphabet, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"alphabet"});
        Supplier<Character> supp = () -> {
            int idx = this.mock.getRandom().nextInt(alphabet.length());
            return Character.valueOf(alphabet.charAt(idx));
        };
        return () -> supp;
    }

    public MockUnit<Character> from(char[] alphabet) {
        ValidationUtils.notEmpty(alphabet, "Input parameter: '%s' should not be NULL.", new Object[]{"alphabet"});
        Supplier<Character> supp = () -> {
            int idx = this.mock.getRandom().nextInt(alphabet.length);
            return Character.valueOf(alphabet[idx]);
        };
        return () -> supp;
    }
}

