/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.time;

import java.time.Month;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitMonth;
import org.apache.commons.lang3.Validate;

public class Months
implements MockUnitMonth {
    private final MockNeat mock;

    public Months(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<Month> supplier() {
        return this.mock.from(Month.class)::val;
    }

    public MockUnitMonth rangeClosed(Month lower, Month upper) {
        Validate.notNull((Object)lower, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lower"});
        Validate.notNull((Object)upper, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upper"});
        Validate.isTrue((lower.getValue() < upper.getValue() ? 1 : 0) != 0, (String)"'lower' Month < 'upper' Month", (Object[])new Object[0]);
        Supplier<Month> supp = () -> {
            int idx = (Integer)this.mock.ints().range(lower.getValue() - 1, upper.getValue()).val();
            return Month.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitMonth range(Month lower, Month upper) {
        Validate.notNull((Object)lower, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lower"});
        Validate.notNull((Object)upper, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upper"});
        Validate.isTrue((lower.getValue() < upper.getValue() ? 1 : 0) != 0, (String)"'lower' Month < 'upper' Month", (Object[])new Object[0]);
        Supplier<Month> supp = () -> {
            int idx = (Integer)this.mock.ints().range(lower.getValue() - 1, upper.getValue() - 1).val();
            return Month.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitMonth before(Month before) {
        Validate.notNull((Object)before, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"before"});
        Validate.isTrue((before.getValue() - 1 > 0 ? 1 : 0) != 0, (String)"Cannot use 'January' as 'before'. 'January' is considered to be the first month of the year.", (Object[])new Object[0]);
        return this.range(Month.values()[0], before);
    }

    public MockUnitMonth after(Month after) {
        Validate.notNull((Object)after, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"after"});
        Validate.isTrue((after.getValue() < Month.values().length - 1 ? 1 : 0) != 0, (String)"Cannot use 'December' as 'after'. 'December' is considered to be the last month of the year.", (Object[])new Object[0]);
        Supplier<Month> supp = () -> {
            int idx = (Integer)this.mock.ints().range(after.getValue(), Month.values().length).val();
            return Month.values()[idx];
        };
        return () -> supp;
    }
}

