/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.time;

import java.time.LocalDate;
import java.time.Month;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitLocalDate;
import org.apache.commons.lang3.Validate;

public class LocalDates
implements MockUnitLocalDate {
    private static final long DEFAULT_DAYS_BEFORE = 10L;
    private static final long DEFAULT_DAYS_AFTER = 10L;
    public static final LocalDate EPOCH_START = LocalDate.ofEpochDay(0L);
    private final MockNeat mock;

    public LocalDates(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<LocalDate> supplier() {
        return this.between(EPOCH_START, LocalDate.now())::val;
    }

    public MockUnitLocalDate thisYear() {
        Supplier<LocalDate> supp = () -> {
            int year = LocalDate.now().getYear();
            int maxDays = LocalDate.now().lengthOfYear() + 1;
            int randDay = (Integer)this.mock.ints().range(1, maxDays).val();
            return LocalDate.ofYearDay(year, randDay);
        };
        return () -> supp;
    }

    public MockUnitLocalDate thisMonth() {
        Supplier<LocalDate> supp = () -> {
            int year = LocalDate.now().getYear();
            Month month = LocalDate.now().getMonth();
            int lM = LocalDate.now().lengthOfMonth() + 1;
            int randDay = (Integer)this.mock.ints().range(1, lM).val();
            return LocalDate.of(year, month, randDay);
        };
        return () -> supp;
    }

    public MockUnitLocalDate between(LocalDate lowerDate, LocalDate upperDate) {
        Validate.notNull((Object)lowerDate, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lowerDate"});
        Validate.notNull((Object)upperDate, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upperDate"});
        Validate.isTrue((lowerDate.compareTo(upperDate) < 0 ? 1 : 0) != 0, (String)"lowerDate '%s' should be < than upperDate '%s'.", (Object[])new Object[]{lowerDate, upperDate});
        Supplier<LocalDate> supp = () -> {
            long lowerEpoch = lowerDate.toEpochDay();
            long upperEpoch = upperDate.toEpochDay();
            long diff = upperEpoch - lowerEpoch;
            long randEpoch = (Long)this.mock.longs().range(0L, diff).val();
            return LocalDate.ofEpochDay(lowerEpoch + randEpoch);
        };
        return () -> supp;
    }

    public MockUnitLocalDate future(LocalDate maxDate) {
        Validate.notNull((Object)maxDate, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"maxDate"});
        Validate.isTrue((maxDate.compareTo(LocalDate.MAX.minusDays(1L)) <= 0 ? 1 : 0) != 0, (String)"'maxDate' (%s)  should be < than '%s' (LocalDates.MAX)", (Object[])new Object[]{maxDate, LocalDate.MAX.minusDays(1L)});
        Validate.isTrue((maxDate.plusDays(1L).compareTo(LocalDate.now()) > 0 ? 1 : 0) != 0, (String)"'maxDate' (%s) should be > than now() (%s).", (Object[])new Object[]{maxDate, LocalDate.now()});
        return this.between(LocalDate.now().plusDays(1L), maxDate.plusDays(1L));
    }

    public MockUnitLocalDate past(LocalDate minDate) {
        Validate.notNull((Object)minDate, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"minDate"});
        Validate.isTrue((minDate.compareTo(LocalDate.MIN) > 0 ? 1 : 0) != 0, (String)"'minDate' (%s) should be > than '%s' (LocalDate.MIN)", (Object[])new Object[]{minDate, LocalDate.MIN});
        Validate.isTrue((minDate.minusDays(1L).compareTo(LocalDate.now()) < 0 ? 1 : 0) != 0, (String)"'minDate' (%s) should be < than now() (%s).", (Object[])new Object[]{minDate, LocalDate.now()});
        return this.between(minDate, LocalDate.now());
    }
}

