/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.time;

import java.time.DayOfWeek;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitDays;
import org.apache.commons.lang3.Validate;

public class Days
implements MockUnitDays {
    private final MockNeat mock;

    public Days(MockNeat mock) {
        this.mock = mock;
    }

    @Override
    public Supplier<DayOfWeek> supplier() {
        return this.mock.from(DayOfWeek.class)::val;
    }

    public MockUnitDays rangeClosed(DayOfWeek lower, DayOfWeek upper) {
        Validate.notNull((Object)lower, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lower"});
        Validate.notNull((Object)upper, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upper"});
        Validate.isTrue((lower.getValue() < upper.getValue() ? 1 : 0) != 0, (String)"'lower' Month < 'upper' Month", (Object[])new Object[0]);
        Supplier<DayOfWeek> supp = () -> {
            int idx = (Integer)this.mock.ints().range(lower.getValue() - 1, upper.getValue()).val();
            return DayOfWeek.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitDays range(DayOfWeek lower, DayOfWeek upper) {
        Validate.notNull((Object)lower, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"lower"});
        Validate.notNull((Object)upper, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"upper"});
        Validate.isTrue((lower.getValue() < upper.getValue() ? 1 : 0) != 0, (String)"'lower' Month < 'upper' Month", (Object[])new Object[0]);
        Supplier<DayOfWeek> supp = () -> {
            int idx = (Integer)this.mock.ints().range(lower.getValue() - 1, upper.getValue() - 1).val();
            return DayOfWeek.values()[idx];
        };
        return () -> supp;
    }

    public MockUnitDays before(DayOfWeek before) {
        Validate.notNull((Object)before, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"before"});
        Validate.isTrue((before.getValue() - 1 > 0 ? 1 : 0) != 0, (String)"Cannot use 'Monday' as 'before'. 'Monday' is considered to be the first day of the week.", (Object[])new Object[0]);
        return this.range(DayOfWeek.values()[0], before);
    }

    public MockUnitDays after(DayOfWeek after) {
        Validate.notNull((Object)after, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"after"});
        Validate.isTrue((after.getValue() - 1 < DayOfWeek.values().length - 1 ? 1 : 0) != 0, (String)"Cannot use 'Sunday' as 'after'. 'Sunday' is considered to be the last day of the week.", (Object[])new Object[0]);
        Supplier<DayOfWeek> supp = () -> {
            int idx = (Integer)this.mock.ints().range(after.getValue(), DayOfWeek.values().length).val();
            return DayOfWeek.values()[idx];
        };
        return () -> supp;
    }
}

