/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.text.markov;

import java.util.Arrays;
import java.util.Map;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.types.Pair;

public class WordStatistic {
    private Double total = 0.0;
    private final Pair<Double, String>[] associatedWords;
    private final MockNeat rand;

    public WordStatistic(Map<String, Integer> rawWordCount) {
        this.associatedWords = new Pair[rawWordCount.size()];
        this.rand = MockNeat.threadLocal();
        this.processRawWordCount(rawWordCount);
    }

    protected void processRawWordCount(Map<String, Integer> rawLine) {
        this.total = this.getTotal(rawLine);
        int i = 0;
        double cv = 0.0;
        for (Map.Entry<String, Integer> entry : rawLine.entrySet()) {
            this.associatedWords[i] = new Pair<Double, String>(cv += (double)entry.getValue().intValue(), entry.getKey());
            ++i;
        }
        Arrays.sort(this.associatedWords, (v1, v2) -> ((Double)v1.getFirst()).compareTo((Double)v2.getFirst()));
    }

    protected Double getTotal(Map<String, Integer> rawLine) {
        return rawLine.values().stream().mapToInt(Integer::intValue).sum();
    }

    public String nextWord() {
        double rd = (Double)this.rand.doubles().bound(this.total).val();
        for (int i = 0; i < this.associatedWords.length; ++i) {
            if (!(rd < this.associatedWords[i].getFirst())) continue;
            return this.associatedWords[i].getSecond();
        }
        return "";
    }
}

