/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.seq;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import net.andreinc.mockneat.interfaces.MockUnitInt;
import org.apache.commons.lang3.Validate;

public class IntSeq
implements MockUnitInt {
    private int increment = 1;
    private int start = 0;
    private boolean cycle = true;
    private int max = Integer.MAX_VALUE;
    private int min = Integer.MIN_VALUE;
    private AtomicInteger internal;

    public IntSeq(int start, int increment, int max, int min, boolean cycle) {
        Validate.isTrue((min < max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{min, max});
        this.increment = increment;
        this.start = start;
        this.cycle = cycle;
        this.max = max;
        this.min = min;
        this.internal = new AtomicInteger(start);
    }

    public IntSeq(int start, int increment) {
        this(start, increment, Integer.MAX_VALUE, Integer.MIN_VALUE, true);
    }

    public IntSeq(int increment) {
        this(0, increment, Integer.MAX_VALUE, Integer.MIN_VALUE, true);
    }

    public IntSeq() {
        this(0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE, true);
    }

    public IntSeq start(int start) {
        Validate.isTrue((this.min < this.max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{this.min, this.max});
        this.start = start;
        this.internal = new AtomicInteger(start);
        return this;
    }

    public IntSeq increment(int increment) {
        this.increment = increment;
        return this;
    }

    public IntSeq cycle(boolean cycle) {
        this.cycle = cycle;
        return this;
    }

    public IntSeq max(int max) {
        Validate.isTrue((this.min < max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{this.min, max});
        this.max = max;
        return this;
    }

    public IntSeq min(int min) {
        Validate.isTrue((min < this.max ? 1 : 0) != 0, (String)"The min value (%d) should be lower than the maximum (%d) value of the sequence.", (Object[])new Object[]{min, this.max});
        this.min = min;
        return this;
    }

    private boolean nextValueOverflows() {
        return this.increment > 0 ? this.internal.get() > this.max : this.internal.get() < this.min;
    }

    private void fail() {
        String fmt = String.format("IntSeq overflow. Values are generated inside the interval: [%d, %d]. Cannot increment any further.", this.min, this.max);
        throw new IllegalStateException(fmt);
    }

    @Override
    public Supplier<Integer> supplier() {
        return () -> {
            if (this.nextValueOverflows()) {
                if (this.cycle) {
                    this.internal.set(this.start);
                } else {
                    this.fail();
                }
            }
            return this.internal.getAndAdd(this.increment);
        };
    }
}

