/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.networking;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.Pair;
import net.andreinc.mockneat.types.enums.DictType;
import net.andreinc.mockneat.types.enums.DomainSuffixType;
import net.andreinc.mockneat.types.enums.HostNameType;
import net.andreinc.mockneat.types.enums.PassStrengthType;
import net.andreinc.mockneat.types.enums.StringFormatType;
import net.andreinc.mockneat.types.enums.URLSchemeType;
import org.apache.commons.lang3.Validate;

public class URLs
implements MockUnitString {
    protected static final Integer[] COMMON_HTTP_PORTS = new Integer[]{80, 1311, 2480, 4567, 4711, 4712, 5104, 5800, 5988, 5989, 7000, 7001, 7002, 8008, 8080, 8088, 8280, 8281, 8530, 8531, 8887, 8888, 9080, 9443, 9981, 9982, 11371, 16080, 18091, 18092};
    private final MockNeat mock;
    private Supplier<String> schemeSupplier;
    private Supplier<String> authSupplier;
    private Supplier<String> userNameSupplier;
    private Supplier<String> passWordSupplier;
    private Supplier<String> hostSupplier;
    private boolean www = true;
    private Supplier<String> domainSupplier;
    private Supplier<String> portSupplier;

    public URLs(MockNeat mock) {
        this.mock = mock;
        this.initializeSuppliers();
    }

    private static String urlFormat(String scheme, String auth, String host, String domain, String port, String paths) {
        StringBuilder buff = new StringBuilder();
        buff.append(scheme).append(auth).append(host).append(domain).append(port).append(paths);
        return buff.toString();
    }

    private void initializeSuppliers() {
        this.schemeSupplier = this.defaultSchemesSupplier();
        this.authSupplier = this.defaultAuthSupplier();
        this.hostSupplier = this.defaultHostSupplier();
        this.domainSupplier = this.defaultDomainSupplier();
        this.portSupplier = this.defaultPortSupplier();
    }

    private Supplier<String> defaultSchemesSupplier() {
        return this.schemeSupplier(URLSchemeType.HTTP);
    }

    private Supplier<String> schemeSupplier(String ... schemes) {
        return this.mock.fromStrings(schemes).append("://")::val;
    }

    private Supplier<String> schemeSupplier(String scheme) {
        if ("".equals(scheme)) {
            return () -> "";
        }
        return () -> scheme.concat("://");
    }

    private Supplier<String> schemeSupplier(URLSchemeType scheme) {
        return this.schemeSupplier(scheme.getStr());
    }

    private Supplier<String> schemeSupplier(URLSchemeType ... schemes) {
        return this.mock.from(schemes).mapToString().append("://")::val;
    }

    public URLs schemes(String ... schemes) {
        Validate.notEmpty((Object[])schemes, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"schemes"});
        IntStream.range(0, schemes.length).forEach(i -> {
            String cfr_ignored_0 = (String)Validate.notEmpty((CharSequence)schemes[i], (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"schemes[" + i + "]"});
        });
        this.schemeSupplier = this.schemeSupplier(schemes);
        return this;
    }

    public URLs scheme(String scheme) {
        Validate.notNull((Object)scheme, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"scheme"});
        this.schemeSupplier = this.schemeSupplier(scheme);
        return this;
    }

    public URLs schemes(URLSchemeType ... schemes) {
        Validate.notEmpty((Object[])schemes, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"schemes"});
        IntStream.range(0, schemes.length).forEach(i -> {
            URLSchemeType cfr_ignored_0 = (URLSchemeType)((Object)((Object)Validate.notNull((Object)((Object)schemes[i]), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"schemes[" + i + "]"})));
        });
        this.schemeSupplier = this.schemeSupplier(schemes);
        return this;
    }

    public URLs scheme(URLSchemeType scheme) {
        Validate.notNull((Object)((Object)scheme), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"scheme"});
        this.schemeSupplier = this.schemeSupplier(scheme);
        return this;
    }

    private Supplier<String> defaultAuthSupplier() {
        return () -> "";
    }

    private Supplier<String> authSupplier() {
        return () -> String.format("%s:%s@", this.userNameSupplier.get(), this.passWordSupplier.get());
    }

    public URLs auth() {
        this.userNameSupplier = this.mock.users().urlEncode().supplier();
        this.passWordSupplier = this.mock.passwords().type(PassStrengthType.MEDIUM).urlEncode().supplier();
        this.authSupplier = this.authSupplier();
        return this;
    }

    private Supplier<String> defaultHostSupplier() {
        return () -> {
            List<Pair<DictType, DictType>> comboList = this.mock.from(HostNameType.class).val().getDictCombos();
            Pair<DictType, DictType> combo = this.mock.from(comboList).val();
            String result = (String)this.mock.dicts().type(combo.getFirst()).noSpecialChars().format(StringFormatType.LOWER_CASE).val() + (String)this.mock.dicts().type(combo.getSecond()).noSpecialChars().format(StringFormatType.LOWER_CASE).val();
            if (this.www) {
                result = "www.".concat(result);
            }
            return result;
        };
    }

    private Supplier<String> hostSupplier(String ... hosts) {
        return this.mock.fromStrings(hosts).prepend(this.www ? "www." : "")::val;
    }

    private Supplier<String> hostSupplier(String host) {
        return () -> this.www ? "www.".concat(host) : host;
    }

    private Supplier<String> hostSupplier(HostNameType ... types) {
        HostNameType type = this.mock.from(types).val();
        return this.hostSupplier(type);
    }

    private Supplier<String> hostSupplier(HostNameType hostNameType) {
        return () -> {
            List<Pair<DictType, DictType>> comboList = hostNameType.getDictCombos();
            Pair<DictType, DictType> combo = this.mock.from(comboList).val();
            String result1 = (String)this.mock.dicts().type(combo.getFirst()).noSpecialChars().val();
            String result2 = (String)this.mock.dicts().type(combo.getSecond()).noSpecialChars().val();
            String result = result1 + result2;
            if (this.www) {
                result = "www.".concat(result);
            }
            return result;
        };
    }

    public URLs hosts(String ... hosts) {
        Validate.notEmpty((Object[])hosts, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"hosts"});
        IntStream.range(0, hosts.length).forEach(i -> {
            String cfr_ignored_0 = (String)Validate.notEmpty((CharSequence)hosts[i], (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"hosts[" + i + "]"});
        });
        this.hostSupplier = this.hostSupplier(hosts);
        return this;
    }

    public URLs host(String host) {
        Validate.notEmpty((CharSequence)host, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"host"});
        this.hostSupplier = this.hostSupplier(host);
        return this;
    }

    public URLs hosts(HostNameType ... hostNameTypes) {
        Validate.notEmpty((Object[])hostNameTypes, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"hostNameTypes"});
        IntStream.range(0, hostNameTypes.length).forEach(i -> {
            HostNameType cfr_ignored_0 = (HostNameType)((Object)((Object)Validate.notNull((Object)((Object)hostNameTypes[i]), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"hostNameTypes[" + i + "]"})));
        });
        this.hostSupplier = this.hostSupplier(hostNameTypes);
        return this;
    }

    public URLs host(HostNameType hostNameType) {
        Validate.notNull((Object)((Object)hostNameType), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"hostNameType"});
        this.hostSupplier = this.hostSupplier(hostNameType);
        return this;
    }

    private Supplier<String> defaultDomainSupplier() {
        return this.domainSupplier(DomainSuffixType.POPULAR);
    }

    private Supplier<String> domainSupplier(DomainSuffixType ... types) {
        return this.mock.domains().types(types).prepend(".")::val;
    }

    private Supplier<String> domainSupplier(DomainSuffixType type) {
        return this.mock.domains().types(type).prepend(".")::val;
    }

    private Supplier<String> domainSupplier(String ... domains) {
        return this.mock.fromStrings(domains).prepend(".")::val;
    }

    private Supplier<String> domainSupplier(String domain) {
        return () -> "." + domain;
    }

    public URLs domains(DomainSuffixType ... types) {
        Validate.notEmpty((Object[])types, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"types"});
        IntStream.range(0, types.length).forEach(i -> {
            DomainSuffixType cfr_ignored_0 = (DomainSuffixType)((Object)((Object)Validate.notNull((Object)((Object)types[i]), (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"types[" + i + "]"})));
        });
        this.domainSupplier = this.domainSupplier(types);
        return this;
    }

    public URLs domain(DomainSuffixType type) {
        Validate.notNull((Object)((Object)type), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"types"});
        this.domainSupplier = this.domainSupplier(type);
        return this;
    }

    public URLs domains(String ... domains) {
        Validate.notEmpty((Object[])domains, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"domains"});
        IntStream.range(0, domains.length).forEach(i -> {
            String cfr_ignored_0 = (String)Validate.notEmpty((CharSequence)domains[i], (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"domains[" + i + "]"});
        });
        this.domainSupplier = this.domainSupplier(domains);
        return this;
    }

    public URLs domain(String domain) {
        Validate.notEmpty((CharSequence)domain, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"domain"});
        this.domainSupplier = this.domainSupplier(domain);
        return this;
    }

    private Supplier<String> defaultPortSupplier() {
        return () -> "";
    }

    private Supplier<String> portsSupplier() {
        return this.portSupplier(COMMON_HTTP_PORTS);
    }

    private Supplier<String> portSupplier(Integer ... array) {
        return this.mock.fromInts(array).mapToString().prepend(":")::val;
    }

    private Supplier<String> portSupplier(Integer port) {
        return () -> ":" + port;
    }

    public URLs ports() {
        this.portSupplier = this.portsSupplier();
        return this;
    }

    public URLs ports(Integer ... array) {
        Validate.notEmpty((Object[])array, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"array"});
        IntStream.range(0, array.length).forEach(i -> {
            Integer cfr_ignored_0 = (Integer)Validate.notNull((Object)array[i], (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"array[" + i + "]"});
        });
        this.portSupplier = this.portSupplier(array);
        return this;
    }

    public URLs port(Integer port) {
        Validate.notNull((Object)port, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"port"});
        this.portSupplier = this.portSupplier(port);
        return this;
    }

    public URLs www(boolean hasWWW) {
        this.www = hasWWW;
        return this;
    }

    @Override
    public Supplier<String> supplier() {
        return () -> {
            String scheme = this.schemeSupplier.get();
            String auth = this.authSupplier.get();
            String host = this.hostSupplier.get();
            String domain = this.domainSupplier.get();
            String port = this.portSupplier.get();
            String paths = "";
            return URLs.urlFormat(scheme, auth, host, domain, port, paths);
        };
    }
}

