/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.misc;

import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.utils.FormatUtils;

public class SSCs
implements MockUnitString {
    private final MockNeat mockNeat;

    public SSCs(MockNeat mockNeat) {
        this.mockNeat = mockNeat;
    }

    @Override
    public Supplier<String> supplier() {
        return () -> this.generateAAA() + "-" + this.generateGG() + "-" + this.generateSSSS();
    }

    private String generateAAA() {
        Integer number = (Integer)this.mockNeat.ints().range(1, 900).val();
        while (number == 666 || number == 78 || number == 219) {
            number = (Integer)this.mockNeat.ints().range(1, 900).val();
        }
        return FormatUtils.prependZeroesToSize(number.toString(), 3);
    }

    private String generateGG() {
        return FormatUtils.prependZeroesToSize(this.mockNeat.ints().range(1, 100).valStr(), 2);
    }

    private String generateSSSS() {
        return FormatUtils.prependZeroesToSize(this.mockNeat.ints().range(1, 10000).valStr(), 4);
    }
}

