/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.unit.financial;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.function.Supplier;
import net.andreinc.mockneat.MockNeat;
import net.andreinc.mockneat.interfaces.MockUnitString;
import org.apache.commons.lang3.Validate;

public class Money
implements MockUnitString {
    private final MockNeat mock;
    private NumberFormat formatter = NumberFormat.getCurrencyInstance(Locale.US);
    public static final double DEFAULT_LOWER = 0.0;
    public static final double DEFAULT_UPPER = 10000.0;

    public Money(MockNeat mock) {
        this.mock = mock;
    }

    public Money locale(Locale locale) {
        Validate.notNull((Object)locale, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"locale"});
        this.formatter = NumberFormat.getCurrencyInstance(locale);
        return this;
    }

    public MockUnitString range(double lowerBound, double upperBound) {
        return () -> this.mock.doubles().range(lowerBound, upperBound).mapToString(this.formatter::format).supplier();
    }

    public MockUnitString bound(double bound) {
        return () -> this.mock.doubles().bound(bound).mapToString(this.formatter::format)::val;
    }

    @Override
    public Supplier<String> supplier() {
        return this.range(0.0, 10000.0).supplier();
    }
}

