/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.interfaces;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.function.Supplier;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.types.enums.StringFormatType;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.Validate;

@FunctionalInterface
public interface MockUnitString
extends MockUnit<String> {
    default public MockUnitString format(StringFormatType formatType) {
        Validate.notNull((Object)((Object)formatType), (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"formatType"});
        Supplier<String> supplier = () -> formatType.getFormatter().apply((String)this.supplier().get());
        return () -> supplier;
    }

    default public MockUnitString sub(int endIndex) {
        return this.sub(0, endIndex);
    }

    default public MockUnitString sub(int beginIndex, int endIndex) {
        Supplier<String> supplier = () -> ((String)this.supplier().get()).substring(beginIndex, endIndex);
        return () -> supplier;
    }

    default public MockUnitString append(String str) {
        Validate.notEmpty((CharSequence)str);
        Supplier<String> supplier = () -> ((String)this.supplier().get()).concat(str);
        return () -> supplier;
    }

    default public MockUnitString prepend(String str) {
        Validate.notEmpty((CharSequence)str);
        Supplier<String> supplier = () -> str.concat((String)this.supplier().get());
        return () -> supplier;
    }

    default public MockUnitString replace(char oldCHar, char newChar) {
        Supplier<String> supplier = () -> ((String)this.supplier().get()).replace(oldCHar, newChar);
        return () -> supplier;
    }

    default public MockUnitString replace(CharSequence target, CharSequence replacement) {
        Supplier<String> supplier = () -> ((String)this.supplier().get()).replace(target, replacement);
        return () -> supplier;
    }

    default public MockUnitString replaceAll(String regex, String replacement) {
        Supplier<String> supplier = () -> ((String)this.supplier().get()).replaceAll(regex, replacement);
        return () -> supplier;
    }

    default public MockUnitString replaceFirst(String regex, String replacement) {
        Supplier<String> supplier = () -> ((String)this.supplier().get()).replaceFirst(regex, replacement);
        return () -> supplier;
    }

    default public MockUnit<String[]> split(String regex, int limit) {
        Supplier<String[]> supplier = () -> ((String)this.supplier().get()).split(regex, limit);
        return () -> supplier;
    }

    default public MockUnit<String[]> split(String regex) {
        return this.split(regex, 0);
    }

    default public MockUnitString urlEncode(String enc) {
        Supplier<String> supplier = () -> {
            String val = (String)this.supplier().get();
            try {
                return URLEncoder.encode(val, enc);
            }
            catch (UnsupportedEncodingException e) {
                String msg = String.format("Cannot URL encode the following string: '%s'.", val);
                throw new IllegalArgumentException(msg, e);
            }
        };
        return () -> supplier;
    }

    default public MockUnitString urlEncode() {
        return this.urlEncode("UTF-8");
    }

    default public MockUnitString noSpecialChars() {
        return () -> () -> ((String)this.supplier().get()).replaceAll("[^\\dA-Za-z ]", "");
    }

    default public MockUnitString escapeCsv() {
        return () -> () -> StringEscapeUtils.escapeCsv((String)((String)this.supplier().get()));
    }

    default public MockUnitString escapeEcmaScript() {
        return () -> () -> StringEscapeUtils.escapeEcmaScript((String)((String)this.supplier().get()));
    }

    default public MockUnitString escapeHtml() {
        return () -> () -> StringEscapeUtils.escapeHtml4((String)((String)this.supplier().get()));
    }

    default public MockUnitString escapeXml() {
        return () -> () -> StringEscapeUtils.escapeXml11((String)((String)this.supplier().get()));
    }

    default public MockUnit<String[]> array(int size) {
        return this.array(String.class, size);
    }
}

