/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.interfaces;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import net.andreinc.mockneat.interfaces.MockUnit;
import org.apache.commons.lang3.Validate;

public interface MockUnitLong
extends MockUnit<Long> {
    default public MockUnit<LongStream> longStream() {
        Supplier<LongStream> supp = () -> LongStream.generate(((Supplier)this.supplier())::get);
        return () -> supp;
    }

    default public MockUnit<long[]> arrayPrimitive(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<long[]> supp = () -> {
            long[] array = new long[size];
            IntStream.range(0, size).forEach(i -> {
                array[i] = (Long)this.val();
            });
            return array;
        };
        return () -> supp;
    }

    default public MockUnit<Long[]> array(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Long[]> supp = () -> {
            Long[] result = new Long[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Long)this.val();
            });
            return result;
        };
        return () -> supp;
    }
}

