/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat.interfaces;

import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.andreinc.mockneat.interfaces.MockUnit;
import org.apache.commons.lang3.Validate;

public interface MockUnitInt
extends MockUnit<Integer> {
    default public MockUnit<IntStream> intStream() {
        Supplier<IntStream> supp = () -> IntStream.generate(((Supplier)this.supplier())::get);
        return () -> supp;
    }

    default public MockUnit<int[]> arrayPrimitive(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<int[]> supp = () -> {
            int[] result = new int[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Integer)this.val();
            });
            return result;
        };
        return () -> supp;
    }

    default public MockUnit<Integer[]> array(int size) {
        Validate.isTrue((size >= 0 ? 1 : 0) != 0, (String)"The size needs to be bigger than 0 (>=).", (Object[])new Object[0]);
        Supplier<Integer[]> supp = () -> {
            Integer[] result = new Integer[size];
            IntStream.range(0, size).forEach(i -> {
                result[i] = (Integer)this.val();
            });
            return result;
        };
        return () -> supp;
    }
}

