/*
 * Decompiled with CFR 0.152.
 */
package net.andreinc.mockneat;

import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import net.andreinc.mockneat.interfaces.MockUnit;
import net.andreinc.mockneat.interfaces.MockUnitDouble;
import net.andreinc.mockneat.interfaces.MockUnitInt;
import net.andreinc.mockneat.interfaces.MockUnitLong;
import net.andreinc.mockneat.interfaces.MockUnitString;
import net.andreinc.mockneat.types.enums.RandomType;
import net.andreinc.mockneat.unit.address.Countries;
import net.andreinc.mockneat.unit.companies.Departments;
import net.andreinc.mockneat.unit.financial.CVVS;
import net.andreinc.mockneat.unit.financial.CreditCards;
import net.andreinc.mockneat.unit.financial.Currencies;
import net.andreinc.mockneat.unit.financial.Money;
import net.andreinc.mockneat.unit.hashes.MD5s;
import net.andreinc.mockneat.unit.id.UUIDs;
import net.andreinc.mockneat.unit.misc.SSCs;
import net.andreinc.mockneat.unit.networking.Domains;
import net.andreinc.mockneat.unit.networking.IPv4s;
import net.andreinc.mockneat.unit.networking.IPv6s;
import net.andreinc.mockneat.unit.networking.Macs;
import net.andreinc.mockneat.unit.networking.URLs;
import net.andreinc.mockneat.unit.objects.Constructor;
import net.andreinc.mockneat.unit.objects.Factory;
import net.andreinc.mockneat.unit.objects.Probabilities;
import net.andreinc.mockneat.unit.objects.Reflect;
import net.andreinc.mockneat.unit.seq.IntSeq;
import net.andreinc.mockneat.unit.seq.LongSeq;
import net.andreinc.mockneat.unit.text.Dicts;
import net.andreinc.mockneat.unit.text.Formatter;
import net.andreinc.mockneat.unit.text.FromFiles;
import net.andreinc.mockneat.unit.text.Markovs;
import net.andreinc.mockneat.unit.text.Strings;
import net.andreinc.mockneat.unit.time.Days;
import net.andreinc.mockneat.unit.time.LocalDates;
import net.andreinc.mockneat.unit.time.Months;
import net.andreinc.mockneat.unit.types.Bools;
import net.andreinc.mockneat.unit.types.Chars;
import net.andreinc.mockneat.unit.types.Doubles;
import net.andreinc.mockneat.unit.types.Floats;
import net.andreinc.mockneat.unit.types.Ints;
import net.andreinc.mockneat.unit.types.Longs;
import net.andreinc.mockneat.unit.user.Emails;
import net.andreinc.mockneat.unit.user.Names;
import net.andreinc.mockneat.unit.user.Passwords;
import net.andreinc.mockneat.unit.user.Users;
import org.apache.commons.lang3.Validate;

public class MockNeat {
    private static final MockNeat THREAD_LOCAL = new MockNeat(RandomType.THREAD_LOCAL);
    private static final MockNeat SECURE = new MockNeat(RandomType.SECURE);
    private static final MockNeat OLD = new MockNeat(RandomType.OLD);
    private final Random random;
    private final Bools rBools;
    private final Countries rCountries;
    private final CreditCards rCCS;
    private final Chars rChars;
    private final Currencies rCurrencies;
    private final CVVS rCVVS;
    private final Days rDays;
    private final Departments rDepartments;
    private final Dicts rDicts;
    private final Domains rDomains;
    private final Doubles rDoubles;
    private final Emails rEmails;
    private final FromFiles rFiles;
    private final Floats rFloats;
    private final Ints rInts;
    private final IPv4s rIPv4s;
    private final IPv6s rIPv6s;
    private final LocalDates rLocalDates;
    private final Longs rLongs;
    private final Macs rMacs;
    private final Markovs rMarkovs;
    private final MD5s rMD5s;
    private final Money rMoney;
    private final Months rMonths;
    private final Names rNames;
    private final Passwords rPasswords;
    private final SSCs rSSCs;
    private final UUIDs rUUIDs;
    private final Users rUsers;

    public MockNeat(RandomType randomTypeType) {
        this.random = randomTypeType.getRandom();
        this.rChars = new Chars(this);
        this.rBools = new Bools(this);
        this.rCountries = new Countries(this);
        this.rCCS = new CreditCards(this);
        this.rCurrencies = new Currencies(this);
        this.rCVVS = new CVVS(this);
        this.rDays = new Days(this);
        this.rDepartments = new Departments(this);
        this.rDomains = new Domains(this);
        this.rDicts = new Dicts(this);
        this.rDoubles = new Doubles(this);
        this.rEmails = new Emails(this);
        this.rFiles = new FromFiles(this);
        this.rFloats = new Floats(this);
        this.rInts = new Ints(this);
        this.rIPv4s = new IPv4s(this);
        this.rIPv6s = new IPv6s(this);
        this.rLocalDates = new LocalDates(this);
        this.rLongs = new Longs(this);
        this.rMacs = new Macs(this);
        this.rMarkovs = new Markovs(this);
        this.rMD5s = new MD5s(this);
        this.rMoney = new Money(this);
        this.rMonths = new Months(this);
        this.rNames = new Names(this);
        this.rPasswords = new Passwords(this);
        this.rSSCs = new SSCs(this);
        this.rUUIDs = new UUIDs();
        this.rUsers = new Users(this);
    }

    protected MockNeat() {
        this(RandomType.THREAD_LOCAL);
    }

    public MockNeat(RandomType randomTypeType, Long seed) {
        this(randomTypeType);
        this.random.setSeed(seed);
    }

    public static MockNeat threadLocal() {
        return THREAD_LOCAL;
    }

    public static MockNeat secure() {
        return SECURE;
    }

    public static MockNeat old() {
        return OLD;
    }

    public Bools bools() {
        return this.rBools;
    }

    public Chars chars() {
        return this.rChars;
    }

    public CreditCards creditCards() {
        return this.rCCS;
    }

    public <T> Constructor<T> constructor(Class<T> cls) {
        return new Constructor<T>(cls);
    }

    public Countries countries() {
        return this.rCountries;
    }

    public Currencies currencies() {
        return this.rCurrencies;
    }

    public CVVS cvvs() {
        return this.rCVVS;
    }

    public Dicts dicts() {
        return this.rDicts;
    }

    public Days days() {
        return this.rDays;
    }

    public Departments departments() {
        return this.rDepartments;
    }

    public Domains domains() {
        return this.rDomains;
    }

    public Doubles doubles() {
        return this.rDoubles;
    }

    public Emails emails() {
        return this.rEmails;
    }

    public <T, FT> Factory<T, FT> factory(Class<T> targetCls, Class<FT> factoryCls) {
        return new Factory<T, FT>(targetCls, factoryCls);
    }

    public FromFiles files() {
        return this.rFiles;
    }

    public Floats floats() {
        return this.rFloats;
    }

    public Formatter fmt(String fmt) {
        return Formatter.formatter(fmt);
    }

    public Ints ints() {
        return this.rInts;
    }

    public IntSeq intSeq() {
        return new IntSeq();
    }

    public IPv4s ipv4s() {
        return this.rIPv4s;
    }

    public IPv6s iPv6s() {
        return this.rIPv6s;
    }

    public LocalDates localDates() {
        return this.rLocalDates;
    }

    public Longs longs() {
        return this.rLongs;
    }

    public LongSeq longSeq() {
        return new LongSeq();
    }

    public Macs macs() {
        return this.rMacs;
    }

    public Markovs markovs() {
        return this.rMarkovs;
    }

    public MD5s md5s() {
        return this.rMD5s;
    }

    public Months months() {
        return this.rMonths;
    }

    public Money money() {
        return this.rMoney;
    }

    public Names names() {
        return this.rNames;
    }

    public Passwords passwords() {
        return this.rPasswords;
    }

    public <T> Probabilities<T> probabilites(Class<T> cls) {
        return new Probabilities<T>(this, cls);
    }

    public <T> Reflect<T> reflect(Class<T> cls) {
        return new Reflect<T>(cls);
    }

    public Strings strings() {
        return new Strings(this);
    }

    public SSCs sccs() {
        return this.rSSCs;
    }

    public URLs urls() {
        return new URLs(this);
    }

    public UUIDs uuids() {
        return this.rUUIDs;
    }

    public Users users() {
        return this.rUsers;
    }

    public Random getRandom() {
        return this.random;
    }

    public <T> MockUnit<T> from(List<T> alphabet) {
        Validate.notEmpty(alphabet, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"alphabet"});
        Supplier<Object> supp = () -> {
            int idx = this.getRandom().nextInt(alphabet.size());
            return alphabet.get(idx);
        };
        return () -> supp;
    }

    public <T> MockUnit<T> from(T[] alphabet) {
        Validate.notEmpty((Object[])alphabet, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"alphabet"});
        Supplier<Object> supp = () -> {
            int idx = this.getRandom().nextInt(alphabet.length);
            return alphabet[idx];
        };
        return () -> supp;
    }

    public <T extends Enum<?>> MockUnit<T> from(Class<T> enumClass) {
        Validate.notNull(enumClass, (String)"Input parameter: '%s' should not be NULL.", (Object[])new Object[]{"enumClass"});
        Enum[] arr = (Enum[])enumClass.getEnumConstants();
        return this.from(arr);
    }

    public <T> MockUnit<T> fromKeys(Map<T, ?> map) {
        Validate.notEmpty(map, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"map"});
        Supplier<Object> supp = () -> {
            Object[] keys = map.keySet().toArray();
            int idx = this.getRandom().nextInt(keys.length);
            return keys[idx];
        };
        return () -> supp;
    }

    public <T> MockUnit<T> fromValues(Map<?, T> map) {
        Validate.notEmpty(map, (String)"Input parameter: '%s' should not be NULL or empty.", (Object[])new Object[]{"map"});
        Supplier<Object> supp = () -> {
            Object[] values = map.values().toArray();
            int idx = this.getRandom().nextInt(values.length);
            return values[idx];
        };
        return () -> supp;
    }

    public MockUnitInt fromInts(Integer ... alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitInt fromInts(int ... alphabet) {
        return () -> this.ints().from(alphabet)::val;
    }

    public MockUnitInt fromInts(List<Integer> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitInt fromIntsValues(Map<?, Integer> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitInt fromIntsKeys(Map<Integer, ?> map) {
        return () -> this.fromKeys(map)::val;
    }

    public MockUnitDouble fromDoubles(Double ... alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitDouble fromDoubles(double ... alphabet) {
        return () -> this.doubles().from(alphabet)::val;
    }

    public MockUnitDouble fromDoubles(List<Double> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitDouble fromDoublesValues(Map<?, Double> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitDouble fromDoublesKeys(Map<Double, ?> map) {
        return () -> this.fromKeys(map)::val;
    }

    public MockUnitLong fromLongs(Long ... alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitLong fromLongs(long ... alphabet) {
        return () -> this.longs().from(alphabet)::val;
    }

    public MockUnitLong fromLongs(List<Long> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitLong fromLongsValues(Map<?, Long> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitLong fromLongsKeys(Map<Long, ?> map) {
        return () -> this.fromKeys(map)::val;
    }

    public MockUnitString fromStrings(String[] alphabet) {
        return () -> () -> this.from(alphabet).val();
    }

    public MockUnitString fromStrings(List<String> alphabet) {
        return () -> this.from(alphabet)::val;
    }

    public MockUnitString fromStringsValues(Map<?, String> map) {
        return () -> this.fromValues(map)::val;
    }

    public MockUnitString fromStringsKeys(Map<String, ?> map) {
        return () -> this.fromKeys(map)::val;
    }
}

