/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.amygdalum.testrecorder.Wrapped;

public class Types {
    private Types() {
    }

    public static Type inferType(List<Type> types) {
        Optional<Class> reduce = types.stream().map(type -> Types.superTypes(Types.baseType(type))).reduce((s1, s2) -> Types.intersectClasses(s1, s2)).map(s -> Types.bestClass(s));
        return (Type)((Object)reduce.orElse(Object.class));
    }

    private static Set<Class<?>> superTypes(Class<?> clazz) {
        LinkedHashSet done = new LinkedHashSet();
        LinkedList todo = new LinkedList();
        todo.add(clazz);
        while (!todo.isEmpty()) {
            Class next = (Class)todo.remove();
            if (done.contains(next) || next == Object.class) continue;
            Class superclass = next.getSuperclass();
            if (superclass != null) {
                todo.add(superclass);
            }
            for (Class<?> nextInterface : next.getInterfaces()) {
                todo.add(nextInterface);
            }
        }
        return done;
    }

    private static Set<Class<?>> intersectClasses(Set<Class<?>> s1, Set<Class<?>> s2) {
        LinkedHashSet result = new LinkedHashSet(s1);
        result.retainAll(s2);
        return result;
    }

    private static Class<?> bestClass(Set<Class<?>> classes) {
        Class<?> bestInterface = null;
        Class bestClass = Object.class;
        for (Class<?> clazz : classes) {
            if (clazz.isInterface()) {
                if (bestInterface == null) {
                    bestInterface = clazz;
                    continue;
                }
                if (!bestInterface.isAssignableFrom(clazz)) continue;
                bestInterface = clazz;
                continue;
            }
            if (!bestClass.isAssignableFrom(clazz)) continue;
            bestClass = clazz;
        }
        if (bestInterface != null) {
            return bestInterface;
        }
        return bestClass;
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException | SecurityException e) {
            return null;
        }
    }

    public static Class<?> baseType(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(Types.baseType(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        if (type instanceof ParameterizedType) {
            return Types.baseType(((ParameterizedType)type).getRawType());
        }
        return Object.class;
    }

    public static Type array(Type componentType) {
        return new GenericArrayTypeImplementation(componentType);
    }

    public static Type component(Type arrayType) {
        if (arrayType instanceof Class && ((Class)arrayType).isArray()) {
            return ((Class)arrayType).getComponentType();
        }
        if (arrayType instanceof GenericArrayType) {
            return ((GenericArrayType)arrayType).getGenericComponentType();
        }
        return Object.class;
    }

    public static boolean equalTypes(Type type1, Type type2) {
        return Types.baseType(type1).equals(Types.baseType(type2));
    }

    public static Optional<Type> typeArgument(Type type, int i) {
        if (type instanceof ParameterizedType) {
            Type[] actualTypeArguments = ((ParameterizedType)type).getActualTypeArguments();
            if (actualTypeArguments == null || actualTypeArguments.length <= i) {
                return Optional.empty();
            }
            return Optional.of(actualTypeArguments[i]);
        }
        return Optional.empty();
    }

    public static Class<?> innerType(Class<?> clazz, String name) {
        for (Class<?> inner : clazz.getDeclaredClasses()) {
            if (!inner.getSimpleName().equals(name)) continue;
            return inner;
        }
        throw new TypeNotPresentException(clazz.getName() + "$" + name, new ClassNotFoundException(clazz.getName() + "$" + name));
    }

    public static Type wrapHidden(Type type) {
        if (Types.isHidden(type)) {
            return Wrapped.class;
        }
        return type;
    }

    public static boolean isHidden(Type type) {
        return !Modifier.isPublic(Types.baseType(type).getModifiers());
    }

    public static boolean isPrimitive(Type type) {
        return type instanceof Class && ((Class)type).isPrimitive();
    }

    public static Type parameterized(Type raw, Type owner, Type ... typeArgs) {
        return new ParameterizedTypeImplementation(raw, owner, typeArgs);
    }

    public static Type wildcard() {
        return new WildcardTypeImplementation();
    }

    public static Type wildcardExtends(Type ... bounds) {
        return new WildcardTypeImplementation().extending(bounds);
    }

    public static Type wildcardSuper(Type ... bounds) {
        return new WildcardTypeImplementation().limiting(bounds);
    }

    private static final class WildcardTypeImplementation
    implements WildcardType {
        private Type[] upperBounds = new Type[0];
        private Type[] lowerBounds = new Type[0];

        public WildcardTypeImplementation extending(Type ... bounds) {
            this.upperBounds = bounds;
            return this;
        }

        public WildcardTypeImplementation limiting(Type ... bounds) {
            this.lowerBounds = bounds;
            return this;
        }

        @Override
        public Type[] getUpperBounds() {
            return this.upperBounds;
        }

        @Override
        public Type[] getLowerBounds() {
            return this.lowerBounds;
        }
    }

    private static final class ParameterizedTypeImplementation
    implements ParameterizedType {
        private Type raw;
        private Type owner;
        private Type[] typeArgs;

        public ParameterizedTypeImplementation(Type raw, Type owner, Type ... typeArgs) {
            this.raw = raw;
            this.owner = owner;
            this.typeArgs = typeArgs;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.owner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.typeArgs;
        }
    }

    private static final class GenericArrayTypeImplementation
    implements GenericArrayType {
        private Type componentType;

        public GenericArrayTypeImplementation(Type componentType) {
            this.componentType = componentType;
        }

        @Override
        public Type getGenericComponentType() {
            return this.componentType;
        }
    }
}

