/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

public final class Throwables {
    private Throwables() {
    }

    public static Throwable capture(WithResult<?> code) {
        return Throwables.capture(code, Throwable.class);
    }

    public static <T extends Throwable> T capture(WithResult<?> code, Class<T> clazz) {
        try {
            code.run();
            return null;
        }
        catch (Throwable exception) {
            if (clazz.isInstance(exception)) {
                return (T)((Throwable)clazz.cast(exception));
            }
            return null;
        }
    }

    public static Throwable capture(WithoutResult code) {
        return Throwables.capture(code, Throwable.class);
    }

    public static <T extends Throwable> T capture(WithoutResult code, Class<T> clazz) {
        try {
            code.run();
            return null;
        }
        catch (Throwable exception) {
            if (clazz.isInstance(exception)) {
                return (T)((Throwable)clazz.cast(exception));
            }
            return null;
        }
    }

    public static interface WithoutResult {
        public void run() throws Throwable;
    }

    public static interface WithResult<T> {
        public T run() throws Throwable;
    }
}

