/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Field;
import java.util.LinkedList;
import java.util.Queue;
import net.amygdalum.testrecorder.util.GenericObject;
import net.amygdalum.testrecorder.util.InputProvider;

public class SetupInput
implements InputProvider {
    private Queue<InputProvision> provided = new LinkedList<InputProvision>();

    public SetupInput provide(Class<?> clazz, String method, Object result, Object ... args) {
        this.provided.add(new InputProvision(clazz, method, result, args));
        return this;
    }

    @Override
    public Object requestInput(Class<?> clazz, String method, Object ... args) {
        InputProvision providedInput = this.provided.remove();
        providedInput.verify(clazz, method, args);
        this.sync(providedInput.args, args);
        return providedInput.result;
    }

    private void sync(Object[] fromArgs, Object[] toArgs) {
        for (int i = 0; i < toArgs.length; ++i) {
            this.sync(fromArgs[i], toArgs[i]);
        }
    }

    private void sync(Object from, Object to) {
        if (from.getClass() != to.getClass()) {
            return;
        }
        Class<?> current = from.getClass();
        if (current.isArray()) {
            GenericObject.copyArrayValues(from, to);
            return;
        }
        while (current != null && current != Object.class) {
            for (Field field : current.getDeclaredFields()) {
                GenericObject.copyField(field, from, to);
            }
            current = current.getSuperclass();
        }
    }

    private static class InputProvision {
        private Class<?> clazz;
        private String method;
        private Object result;
        private Object[] args;

        public InputProvision(Class<?> clazz, String method, Object result, Object ... args) {
            this.clazz = clazz;
            this.method = method;
            this.result = result;
            this.args = args;
        }

        public void verify(Class<?> clazz, String method, Object[] args) {
            if (!this.clazz.equals(clazz)) {
                throw new AssertionError((Object)("expected output " + this.clazz.getName() + ", but found " + clazz.getName()));
            }
            if (!this.method.equals(method)) {
                throw new AssertionError((Object)("expected output " + this.method + ", but found " + method));
            }
            if (this.args.length != args.length) {
                throw new AssertionError((Object)("expected output " + this.args.length + " arguments, but found " + args.length + " arguments"));
            }
        }
    }
}

