/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public class Reflections {
    public static <T extends AccessibleObject> Accessing<T> accessing(T o) {
        return new Accessing<T>(o);
    }

    public static interface AccessConsumer<T> {
        public void accept() throws ReflectiveOperationException;
    }

    public static interface AccessFunction<T, S> {
        public S apply() throws ReflectiveOperationException;
    }

    public static class Accessing<T extends AccessibleObject> {
        private T object;

        public Accessing(T object) {
            this.object = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S> S call(AccessFunction<T, S> code) throws ReflectiveOperationException {
            boolean reset = this.ensureAccess();
            try {
                S result;
                S s = result = code.apply();
                return s;
            }
            finally {
                this.resetAccess(reset);
            }
        }

        public void exec(AccessConsumer<T> code) throws ReflectiveOperationException {
            boolean reset = this.ensureAccess();
            try {
                code.accept();
            }
            finally {
                this.resetAccess(reset);
            }
        }

        private boolean ensureAccess() {
            if (Modifier.isPublic(((Member)this.object).getModifiers()) && Modifier.isPublic(((Member)this.object).getDeclaringClass().getModifiers())) {
                return false;
            }
            if (!((AccessibleObject)this.object).isAccessible()) {
                ((AccessibleObject)this.object).setAccessible(true);
                return true;
            }
            return false;
        }

        private void resetAccess(boolean reset) {
            if (reset) {
                ((AccessibleObject)this.object).setAccessible(false);
            }
        }
    }
}

