/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.io.IOException;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.ByteCode;
import net.amygdalum.testrecorder.SnapshotInput;
import net.amygdalum.testrecorder.SnapshotOutput;
import net.amygdalum.testrecorder.dynamiccompile.DynamicClassLoader;
import net.amygdalum.testrecorder.util.InputProvider;
import net.amygdalum.testrecorder.util.OutputListener;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class IORecorderClassLoader
extends URLClassLoader {
    private static final String Class_name = Type.getInternalName(Class.class);
    private static final String IORecorderClassLoader_name = Type.getInternalName(IORecorderClassLoader.class);
    private static final String InputProvider_name = Type.getInternalName(InputProvider.class);
    private static final String OutputListener_name = Type.getInternalName(OutputListener.class);
    private static final String SnapshotInput_descriptor = Type.getDescriptor(SnapshotInput.class);
    private static final String SnapshotOutput_descriptor = Type.getDescriptor(SnapshotOutput.class);
    private static final String Class_getClassLoader_descriptor = ByteCode.methodDescriptor(Class.class, "getClassLoader", new Class[0]);
    private static final String IORecorderClassLoader_getOut_descriptor = ByteCode.methodDescriptor(IORecorderClassLoader.class, "getOut", new Class[0]);
    private static final String IORecorderClassLoader_getIn_descriptor = ByteCode.methodDescriptor(IORecorderClassLoader.class, "getIn", new Class[0]);
    private static final String InputProvider_requestInput_descriptor = ByteCode.methodDescriptor(InputProvider.class, "requestInput", Class.class, String.class, Object[].class);
    private static final String OutputListener_notifyOutput_descriptor = ByteCode.methodDescriptor(OutputListener.class, "notifyOutput", Class.class, String.class, Object[].class);
    private ClassLoader orig;
    private InputProvider in;
    private OutputListener out;
    private Set<String> classes;
    private String root;

    public IORecorderClassLoader(ClassLoader orig, String root, InputProvider in, OutputListener out, Set<String> classes) {
        super(((URLClassLoader)IORecorderClassLoader.getSystemClassLoader()).getURLs());
        this.orig = orig;
        this.root = root;
        this.in = in;
        this.out = out;
        this.classes = classes;
    }

    public InputProvider getIn() {
        return this.in;
    }

    public OutputListener getOut() {
        return this.out;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!this.classes.contains(name)) {
            byte[] bytes;
            if (this.orig instanceof DynamicClassLoader && (bytes = ((DynamicClassLoader)this.orig).getBytes(name)) != null) {
                return this.defineClass(name, bytes, 0, bytes.length);
            }
            if (name.contains(this.root)) {
                return this.findClass(name);
            }
            return super.loadClass(name);
        }
        try {
            byte[] bytes = this.instrument(name);
            return this.defineClass(name, bytes, 0, bytes.length);
        }
        catch (Throwable t) {
            throw new ClassNotFoundException(t.getMessage(), t);
        }
    }

    public byte[] instrument(String className) throws IOException {
        return this.instrument(new ClassReader(className));
    }

    public byte[] instrument(ClassReader cr) {
        ClassNode classNode = new ClassNode();
        cr.accept((ClassVisitor)classNode, 0);
        this.instrumentInputMethods(classNode);
        this.instrumentOutputMethods(classNode);
        ClassWriter out = new ClassWriter(3);
        classNode.accept((ClassVisitor)out);
        return out.toByteArray();
    }

    private void instrumentInputMethods(ClassNode classNode) {
        for (MethodNode method : this.getInputMethods(classNode)) {
            method.instructions.clear();
            method.instructions.insert(this.readInput(classNode, method));
        }
    }

    private void instrumentOutputMethods(ClassNode classNode) {
        for (MethodNode method : this.getOutputMethods(classNode)) {
            method.instructions.insert(this.notifyOutput(classNode, method));
        }
    }

    private List<MethodNode> getInputMethods(ClassNode classNode) {
        return classNode.methods.stream().filter(method -> this.isInputMethod((MethodNode)method)).collect(Collectors.toList());
    }

    private boolean isInputMethod(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        return method.visibleAnnotations.stream().anyMatch(annotation -> annotation.desc.equals(SnapshotInput_descriptor));
    }

    private List<MethodNode> getOutputMethods(ClassNode classNode) {
        return classNode.methods.stream().filter(method -> this.isOutputMethod((MethodNode)method)).collect(Collectors.toList());
    }

    private boolean isOutputMethod(MethodNode method) {
        if (method.visibleAnnotations == null) {
            return false;
        }
        return method.visibleAnnotations.stream().anyMatch(annotation -> annotation.desc.equals(SnapshotOutput_descriptor));
    }

    private InsnList readInput(ClassNode classNode, MethodNode methodNode) {
        Type returnType = Type.getReturnType((String)methodNode.desc);
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        LabelNode skip = new LabelNode();
        LabelNode done = new LabelNode();
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)classNode.name)));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, Class_name, "getClassLoader", Class_getClassLoader_descriptor, false));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new JumpInsnNode(198, skip));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new TypeInsnNode(193, IORecorderClassLoader_name));
        insnList.add((AbstractInsnNode)new JumpInsnNode(153, skip));
        insnList.add((AbstractInsnNode)new TypeInsnNode(192, IORecorderClassLoader_name));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, IORecorderClassLoader_name, "getIn", IORecorderClassLoader_getIn_descriptor, false));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new JumpInsnNode(198, skip));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)classNode.name)));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)methodNode.name));
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, InputProvider_name, "requestInput", InputProvider_requestInput_descriptor, true));
        insnList.add(this.returnValue(returnType));
        insnList.add((AbstractInsnNode)skip);
        insnList.add((AbstractInsnNode)new InsnNode(87));
        insnList.add(this.returnDefaultValue(returnType));
        insnList.add((AbstractInsnNode)done);
        return insnList;
    }

    private InsnList returnValue(Type returnType) {
        InsnList insnList = new InsnList();
        if (returnType.getSize() == 0) {
            insnList.add((AbstractInsnNode)new InsnNode(177));
            return insnList;
        }
        insnList.add(ByteCode.unboxPrimitives(returnType));
        switch (returnType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                insnList.add((AbstractInsnNode)new InsnNode(172));
                break;
            }
            case 7: {
                insnList.add((AbstractInsnNode)new InsnNode(173));
                break;
            }
            case 6: {
                insnList.add((AbstractInsnNode)new InsnNode(174));
                break;
            }
            case 8: {
                insnList.add((AbstractInsnNode)new InsnNode(175));
                break;
            }
            default: {
                insnList.add((AbstractInsnNode)new TypeInsnNode(192, returnType.getInternalName()));
                insnList.add((AbstractInsnNode)new InsnNode(176));
            }
        }
        return insnList;
    }

    private InsnList returnDefaultValue(Type returnType) {
        InsnList insnList = new InsnList();
        if (returnType.getSize() == 0) {
            insnList.add((AbstractInsnNode)new InsnNode(177));
            return insnList;
        }
        switch (returnType.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                insnList.add((AbstractInsnNode)new InsnNode(3));
                insnList.add((AbstractInsnNode)new InsnNode(172));
                break;
            }
            case 7: {
                insnList.add((AbstractInsnNode)new InsnNode(9));
                insnList.add((AbstractInsnNode)new InsnNode(173));
                break;
            }
            case 6: {
                insnList.add((AbstractInsnNode)new InsnNode(11));
                insnList.add((AbstractInsnNode)new InsnNode(174));
                break;
            }
            case 8: {
                insnList.add((AbstractInsnNode)new InsnNode(14));
                insnList.add((AbstractInsnNode)new InsnNode(175));
                break;
            }
            default: {
                insnList.add((AbstractInsnNode)new InsnNode(1));
                insnList.add((AbstractInsnNode)new TypeInsnNode(192, returnType.getInternalName()));
                insnList.add((AbstractInsnNode)new InsnNode(176));
            }
        }
        return insnList;
    }

    private InsnList notifyOutput(ClassNode classNode, MethodNode methodNode) {
        Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
        List<LocalVariableNode> arguments = ByteCode.range(methodNode.localVariables, 1, argumentTypes.length);
        InsnList insnList = new InsnList();
        LabelNode skip = new LabelNode();
        LabelNode done = new LabelNode();
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)classNode.name)));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, Class_name, "getClassLoader", Class_getClassLoader_descriptor, false));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new JumpInsnNode(198, skip));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new TypeInsnNode(193, IORecorderClassLoader_name));
        insnList.add((AbstractInsnNode)new JumpInsnNode(153, skip));
        insnList.add((AbstractInsnNode)new TypeInsnNode(192, IORecorderClassLoader_name));
        insnList.add((AbstractInsnNode)new MethodInsnNode(182, IORecorderClassLoader_name, "getOut", IORecorderClassLoader_getOut_descriptor, false));
        insnList.add((AbstractInsnNode)new InsnNode(89));
        insnList.add((AbstractInsnNode)new JumpInsnNode(198, skip));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getObjectType((String)classNode.name)));
        insnList.add((AbstractInsnNode)new LdcInsnNode((Object)methodNode.name));
        insnList.add(ByteCode.pushAsArray(arguments, argumentTypes));
        insnList.add((AbstractInsnNode)new MethodInsnNode(185, OutputListener_name, "notifyOutput", OutputListener_notifyOutput_descriptor, true));
        insnList.add((AbstractInsnNode)new JumpInsnNode(167, done));
        insnList.add((AbstractInsnNode)skip);
        insnList.add((AbstractInsnNode)new InsnNode(87));
        insnList.add((AbstractInsnNode)done);
        return insnList;
    }
}

