/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashSet;
import net.amygdalum.testrecorder.util.ExpectedOutput;
import net.amygdalum.testrecorder.util.IORecorderClassLoader;
import net.amygdalum.testrecorder.util.RecordInput;
import net.amygdalum.testrecorder.util.RecordOutput;
import net.amygdalum.testrecorder.util.SetupInput;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.TestClass;

public class IORecorder
extends BlockJUnit4ClassRunner {
    private IORecorderClassLoader loader;
    private volatile SetupInput setupInput;
    private volatile ExpectedOutput expectedOutput;

    public IORecorder(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected Object createTest() throws Exception {
        Object test = super.createTest();
        for (Field field : test.getClass().getDeclaredFields()) {
            if (field.getType() == ExpectedOutput.class) {
                field.setAccessible(true);
                field.set(test, this.expectedOutput);
            }
            if (field.getType() != SetupInput.class) continue;
            field.setAccessible(true);
            field.set(test, this.setupInput);
        }
        return test;
    }

    protected TestClass createTestClass(Class<?> testClass) {
        return super.createTestClass(this.instrumented(testClass));
    }

    private Class<?> instrumented(Class<?> klass) {
        try {
            RecordOutput outputs = klass.getAnnotation(RecordOutput.class);
            RecordInput inputs = klass.getAnnotation(RecordInput.class);
            this.loader = this.createLoader(klass, inputs, outputs);
            return this.loader.loadClass(klass.getName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private IORecorderClassLoader createLoader(Class<?> klass, RecordInput input, RecordOutput output) {
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        if (output != null) {
            classes.addAll(Arrays.asList(output.value()));
        }
        if (input != null) {
            classes.addAll(Arrays.asList(input.value()));
        }
        IORecorderClassLoader classLoader = new IORecorderClassLoader(klass.getClassLoader(), klass.getName(), this.fetchSetupInput(), this.fetchExpectedOutput(), classes);
        return classLoader;
    }

    private synchronized ExpectedOutput fetchExpectedOutput() {
        if (this.expectedOutput == null) {
            this.expectedOutput = new ExpectedOutput();
        }
        return this.expectedOutput;
    }

    private synchronized SetupInput fetchSetupInput() {
        if (this.setupInput == null) {
            this.setupInput = new SetupInput();
        }
        return this.setupInput;
    }
}

