/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.testrecorder.Wrapped;
import net.amygdalum.testrecorder.util.GenericComparison;
import net.amygdalum.testrecorder.util.GenericObject;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public class GenericMatcher
extends GenericObject {
    public <T> Matcher<T> matching(Class<T> clazz) {
        return new InternalsMatcher<T>(clazz);
    }

    public Matcher<Wrapped> matching(Wrapped wrapped) {
        return new InternalsMatcher(wrapped.getWrappedClass());
    }

    public <T, S> Matcher<S> matching(Class<T> clazz, Class<S> to) {
        return new CastingMatcher<S, T>(to, new InternalsMatcher<T>(clazz));
    }

    public Matcher<Wrapped> matching(Wrapped clazz, Wrapped to) {
        return new CastingMatcher(to.getWrappedClass(), (Matcher<?>)new InternalsMatcher(clazz.getWrappedClass()));
    }

    public <S> Matcher<S> matching(Wrapped clazz, Class<S> to) {
        return new CastingMatcher(to, (Matcher<?>)new InternalsMatcher(clazz.getWrappedClass()));
    }

    public boolean matches(Object o) {
        LinkedList<GenericComparison> remainder = new LinkedList<GenericComparison>();
        for (Field field : this.getGenericFields()) {
            Field to;
            if (GenericComparison.equals(this, field, o, to = GenericMatcher.findField(field.getName(), o.getClass()), remainder)) continue;
            return false;
        }
        while (!remainder.isEmpty()) {
            Object value;
            Matcher matcher;
            GenericComparison current = (GenericComparison)remainder.remove();
            if (!(current.getLeft() instanceof Matcher ? !(matcher = (Matcher)current.getLeft()).matches(value = current.getRight()) : !current.eval(remainder))) continue;
            return false;
        }
        return true;
    }

    public static <T> Matcher<T> recursive(Class<T> clazz) {
        return Matchers.instanceOf(clazz);
    }

    public static Matcher<?> recursive(Wrapped wrapped) {
        return Matchers.instanceOf(wrapped.getWrappedClass());
    }

    private class CastingMatcher<S, T>
    extends TypeSafeMatcher<S> {
        private Class<S> clazz;
        private Matcher<T> matcher;

        public CastingMatcher(Class<S> clazz, Matcher<T> matcher) {
            this.clazz = clazz;
            this.matcher = matcher;
        }

        public void describeTo(Description description) {
            description.appendDescriptionOf(this.matcher);
        }

        protected boolean matchesSafely(S item) {
            if (!this.clazz.isInstance(item)) {
                return false;
            }
            return this.matcher.matches(item);
        }
    }

    private class InternalsMatcher<T>
    extends TypeSafeMatcher<T> {
        private Class<T> clazz;

        public InternalsMatcher(Class<T> clazz) {
            this.clazz = clazz;
        }

        public void describeTo(Description description) {
            description.appendText("of class : ").appendValue((Object)this.clazz.getName()).appendText("\n");
            description.appendText("with fields:");
            for (Field field : GenericMatcher.this.getGenericFields()) {
                this.describeField(description, field, GenericMatcher.this);
            }
        }

        protected boolean matchesSafely(T item) {
            return this.clazz == item.getClass() && GenericMatcher.this.matches(item);
        }

        protected void describeMismatchSafely(T item, Description mismatchDescription) {
            if (item == null) {
                mismatchDescription.appendText("is").appendValue(null);
            } else {
                mismatchDescription.appendText("of class : ").appendValue((Object)item.getClass().getName()).appendText("\n");
                mismatchDescription.appendText("with fields:");
                for (Field field : this.fields(item.getClass())) {
                    this.describeField(mismatchDescription, field, item);
                }
            }
        }

        private List<Field> fields(Class<?> clazz) {
            ArrayList<Field> fields = new ArrayList<Field>();
            while (clazz != null && clazz != Object.class) {
                for (Field field : clazz.getDeclaredFields()) {
                    fields.add(field);
                }
                clazz = clazz.getSuperclass();
            }
            return fields;
        }

        private void describeField(Description description, Field field, Object object) {
            try {
                description.appendText("\n\t").appendText(field.getType().getSimpleName()).appendText(" ").appendText(field.getName()).appendText(":");
                Object value = GenericComparison.getValue(field, object);
                if (value instanceof SelfDescribing) {
                    description.appendDescriptionOf((SelfDescribing)value);
                } else {
                    description.appendValue(value);
                }
            }
            catch (ReflectiveOperationException e) {
                description.appendText("\n\t").appendValue(field.getType()).appendText(" ").appendValue((Object)field.getName()).appendText(":<description failed>");
            }
        }
    }
}

