/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import com.almondtools.xrayinterface.XRayInterface;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SerializerFactory;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedList;

public class CollectionsListSerializer
extends HiddenInnerClassSerializer<SerializedList> {
    public CollectionsListSerializer(SerializerFacade facade) {
        super(Collections.class, facade);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().filter(TypeSelector.startingWith("Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton")).filter(clazz -> List.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public SerializedList generate(Type resultType, Type type) {
        return new SerializedList(type).withResult(resultType);
    }

    @Override
    public void populate(SerializedList serializedObject, Object object) {
        Type newType;
        ArrayList<Type> elementTypes = new ArrayList<Type>();
        for (Object element : (List)object) {
            serializedObject.add(this.facade.serialize(element.getClass(), element));
            if (element == null) continue;
            elementTypes.add(element.getClass());
        }
        if (object.getClass().getSimpleName().contains("Checked")) {
            newType = Types.parameterized(List.class, null, new Type[]{((CheckedList)XRayInterface.xray((Object)object).to(CheckedList.class)).getType()});
            serializedObject.setResultType(newType);
        } else {
            newType = Types.parameterized(List.class, null, new Type[]{Types.inferType(elementTypes)});
            serializedObject.setResultType(newType);
        }
    }

    public static class Factory
    implements SerializerFactory<SerializedList> {
        public CollectionsListSerializer newSerializer(SerializerFacade facade) {
            return new CollectionsListSerializer(facade);
        }
    }

    static interface CheckedList {
        public Class<?> getType();
    }
}

