/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.serializers;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.SerializerFacade;
import net.amygdalum.testrecorder.SerializerFactory;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.serializers.HiddenInnerClassSerializer;
import net.amygdalum.testrecorder.values.SerializedList;

public class ArraysListSerializer
extends HiddenInnerClassSerializer<SerializedList> {
    public ArraysListSerializer(SerializerFacade facade) {
        super(Arrays.class, facade);
    }

    @Override
    public List<Class<?>> getMatchingClasses() {
        return this.innerClasses().filter(TypeSelector.in("ArrayList")).filter(clazz -> List.class.isAssignableFrom((Class<?>)clazz)).collect(Collectors.toList());
    }

    @Override
    public SerializedList generate(Type resultType, Type type) {
        return new SerializedList(type).withResult(resultType);
    }

    @Override
    public void populate(SerializedList serializedObject, Object object) {
        for (Object element : (List)object) {
            serializedObject.add(this.facade.serialize(element.getClass(), element));
        }
    }

    public static class Factory
    implements SerializerFactory<SerializedList> {
        public ArraysListSerializer newSerializer(SerializerFacade facade) {
            return new ArraysListSerializer(facade);
        }
    }
}

