/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.dynamiccompile;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;
import net.amygdalum.testrecorder.dynamiccompile.DynamicClassCompilerException;
import net.amygdalum.testrecorder.dynamiccompile.DynamicClassLoader;

public class DynamicClassCompiler {
    private static final Pattern PACKAGE = Pattern.compile("package\\s+((\\w+\\s*\\.\\s*)*\\w+)\\s*;");
    private static final Pattern NAME = Pattern.compile("public\\s+class\\s+(\\w+)");
    private static ThreadLocal<Map<String, Class<?>>> compiled = ThreadLocal.withInitial(HashMap::new);
    private JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();

    public Class<?> compile(String sourceCode) throws DynamicClassCompilerException {
        if (this.isCached(sourceCode)) {
            return this.fromCache(sourceCode);
        }
        String name = this.findName(sourceCode);
        String pkg = this.findPackage(sourceCode);
        String fullQualifiedName = pkg + '.' + name;
        JavaInMemoryFileManager fileManager = new JavaInMemoryFileManager(this.compiler.getStandardFileManager(null, null, null));
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.compiler.getTask(null, fileManager, diagnostics, null, null, Arrays.asList(new JavaSourceFileObject(name, sourceCode)));
        boolean success = task.call();
        if (!success) {
            throw new DynamicClassCompilerException("compile failed with messages", this.collectMessages(diagnostics.getDiagnostics()));
        }
        try {
            Class<?> clazz = fileManager.getClassLoader(null).loadClass(fullQualifiedName);
            this.cache(sourceCode, clazz);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            throw new DynamicClassCompilerException("clazz " + fullQualifiedName + " cannot be loaded: " + e.getMessage());
        }
    }

    private List<String> collectMessages(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        return diagnostics.stream().map(diagnostic -> this.messageOf((Diagnostic<? extends JavaFileObject>)diagnostic)).collect(Collectors.toList());
    }

    private String messageOf(Diagnostic<? extends JavaFileObject> diagnostic) {
        return diagnostic.getLineNumber() + ":" + diagnostic.getColumnNumber() + "\t" + diagnostic.getMessage(Locale.getDefault());
    }

    private boolean isCached(String sourceCode) {
        return compiled.get().containsKey(sourceCode);
    }

    private Class<?> fromCache(String sourceCode) {
        return compiled.get().get(sourceCode);
    }

    private void cache(String sourceCode, Class<?> clazz) {
        compiled.get().put(sourceCode, clazz);
    }

    private String findPackage(String item) throws DynamicClassCompilerException {
        Matcher packageMatcher = PACKAGE.matcher(item);
        boolean packageFound = packageMatcher.find();
        if (!packageFound) {
            throw new DynamicClassCompilerException("given code contains no package declaration");
        }
        return packageMatcher.group(1);
    }

    private String findName(String item) throws DynamicClassCompilerException {
        Matcher nameMatcher = NAME.matcher(item);
        boolean nameFound = nameMatcher.find();
        if (!nameFound) {
            throw new DynamicClassCompilerException("given code contains no public class");
        }
        return nameMatcher.group(1);
    }

    private static class JavaInMemoryFileManager
    extends ForwardingJavaFileManager<JavaFileManager> {
        private List<JavaClassFileObject> files = new ArrayList<JavaClassFileObject>();

        public JavaInMemoryFileManager(JavaFileManager fileManager) {
            super(fileManager);
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (kind == JavaFileObject.Kind.CLASS) {
                JavaClassFileObject file = new JavaClassFileObject(className);
                this.files.add(file);
                return file;
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return new DynamicClassLoader(this.files);
        }
    }

    static class JavaClassFileObject
    extends SimpleJavaFileObject {
        private String name;
        private final ByteArrayOutputStream bos = new ByteArrayOutputStream();

        public JavaClassFileObject(String name) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.CLASS.extension), JavaFileObject.Kind.CLASS);
            this.name = name;
        }

        public byte[] getBytes() {
            return this.bos.toByteArray();
        }

        public String getClassName() {
            return this.name;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return this.bos;
        }
    }

    private static class JavaSourceFileObject
    extends SimpleJavaFileObject {
        private final String code;

        JavaSourceFileObject(String name, String code) {
            super(URI.create("string:///" + name.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

