/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedSet;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DefaultSetAdaptor
extends DefaultAdaptor<SerializedSet, ObjectToMatcherCode>
implements Adaptor<SerializedSet, ObjectToMatcherCode> {
    @Override
    public Computation tryDeserialize(SerializedSet value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        if (value.isEmpty()) {
            types.staticImport(Matchers.class, "empty");
            String emptyMatcher = Templates.emptyMatcher();
            return new Computation(emptyMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}), Collections.emptyList());
        }
        types.staticImport(Matchers.class, "containsInAnyOrder");
        List elements = value.stream().map(element -> generator.simpleValue((SerializedValue)element)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String containsInAnyOrderMatcher = Templates.containsInAnyOrderMatcher(elementValues);
        return new Computation(containsInAnyOrderMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}), elementComputations);
    }
}

