/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.MapMatcher;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedMap;
import org.hamcrest.Matcher;

public class DefaultMapAdaptor
extends DefaultAdaptor<SerializedMap, ObjectToMatcherCode>
implements Adaptor<SerializedMap, ObjectToMatcherCode> {
    @Override
    public Computation tryDeserialize(SerializedMap value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        String keyType = types.getSimpleName(value.getMapKeyType());
        String valueType = types.getSimpleName(value.getMapValueType());
        if (value.isEmpty()) {
            types.staticImport(MapMatcher.class, "noEntries");
            String noEntriesMatcher = Templates.noEntriesMatcher(keyType, valueType);
            return new Computation(noEntriesMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}), Collections.emptyList());
        }
        types.staticImport(MapMatcher.class, "containsEntries");
        Map<Computation, Computation> elements = value.entrySet().stream().collect(Collectors.toMap(entry -> generator.simpleValue((SerializedValue)entry.getKey()), entry -> generator.simpleValue((SerializedValue)entry.getValue())));
        List<String> entryComputations = elements.entrySet().stream().flatMap(entry -> Stream.concat(((Computation)entry.getKey()).getStatements().stream(), ((Computation)entry.getValue()).getStatements().stream())).collect(Collectors.toList());
        Set<Map.Entry<String, String>> entryValues = elements.entrySet().stream().collect(Collectors.toMap(entry -> ((Computation)entry.getKey()).getValue(), entry -> ((Computation)entry.getValue()).getValue())).entrySet();
        String containsEntriesMatcher = Templates.containsEntriesMatcher(keyType, valueType, entryValues);
        return new Computation(containsEntriesMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}), entryComputations);
    }
}

