/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.Collections;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.EnumMatcher;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedEnum;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DefaultEnumAdaptor
extends DefaultAdaptor<SerializedEnum, ObjectToMatcherCode>
implements Adaptor<SerializedEnum, ObjectToMatcherCode> {
    @Override
    public boolean matches(Type type) {
        return Types.baseType(type).isEnum();
    }

    @Override
    public Computation tryDeserialize(SerializedEnum value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        types.registerType(value.getType());
        if (Types.isHidden(value.getType())) {
            types.staticImport(EnumMatcher.class, "matchingEnum");
        } else {
            types.staticImport(Matchers.class, "sameInstance");
        }
        String typeName = types.getBestName(value.getType());
        String name = value.getName();
        String matchingValue = Templates.fieldAccess(typeName, name);
        if (Types.isHidden(value.getType())) {
            String enumMatcher = Templates.enumMatcher(Templates.asLiteral(value.getName()));
            return new Computation(enumMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcardExtends(new Type[]{Enum.class})}), Collections.emptyList());
        }
        String enumMatcher = Templates.sameInstanceMatcher(matchingValue);
        return new Computation(enumMatcher, Types.parameterized(Matcher.class, null, new Type[]{value.getType()}), Collections.emptyList());
    }
}

