/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.Collections;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class DefaultBigIntegerAdaptor
extends DefaultAdaptor<SerializedImmutable<BigInteger>, ObjectToMatcherCode>
implements Adaptor<SerializedImmutable<BigInteger>, ObjectToMatcherCode> {
    @Override
    public boolean matches(Type type) {
        return Types.equalTypes(type, BigInteger.class);
    }

    @Override
    public Computation tryDeserialize(SerializedImmutable<BigInteger> value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(BigInteger.class);
        types.staticImport(Matchers.class, "equalTo");
        String literal = Templates.asLiteral(value.getValue().toString());
        String bigIntegerLiteral = Templates.newObject("BigInteger", literal);
        String equalToMatcher = Templates.equalToMatcher(bigIntegerLiteral);
        return new Computation(equalToMatcher, Types.parameterized(Matcher.class, null, new Type[]{value.getType()}), Collections.emptyList());
    }
}

