/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.matcher;

import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.matcher.ObjectToMatcherCode;
import net.amygdalum.testrecorder.util.PrimitiveArrayMatcher;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsArrayContainingInOrder;
import org.hamcrest.collection.IsArrayWithSize;

public class DefaultArrayAdaptor
extends DefaultAdaptor<SerializedArray, ObjectToMatcherCode>
implements Adaptor<SerializedArray, ObjectToMatcherCode> {
    @Override
    public Computation tryDeserialize(SerializedArray value, ObjectToMatcherCode generator) {
        TypeManager types = generator.getTypes();
        if (Types.isPrimitive(value.getComponentType())) {
            String name = value.getComponentType().getTypeName();
            types.staticImport(PrimitiveArrayMatcher.class, name + "ArrayContaining");
            List elements = Stream.of(value.getArray()).map(element -> generator.simpleValue((SerializedValue)element)).collect(Collectors.toList());
            List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
            String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
            String primitiveArrayContainingMatcher = Templates.primitiveArrayContainingMatcher(name, elementValues);
            return new Computation(primitiveArrayContainingMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}), elementComputations);
        }
        if (value.getArrayAsList().isEmpty()) {
            types.staticImport(IsArrayWithSize.class, "emptyArray");
            String arrayEmptyMatcher = Templates.arrayEmptyMatcher();
            return new Computation(arrayEmptyMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}));
        }
        types.staticImport(IsArrayContainingInOrder.class, "arrayContaining");
        List elements = Stream.of(value.getArray()).map(element -> generator.simpleValue((SerializedValue)element)).collect(Collectors.toList());
        List<String> elementComputations = elements.stream().flatMap(element -> element.getStatements().stream()).collect(Collectors.toList());
        String[] elementValues = (String[])elements.stream().map(element -> element.getValue()).toArray(String[]::new);
        String arrayContainingMatcher = Templates.arrayContainingMatcher(elementValues);
        return new Computation(arrayContainingMatcher, Types.parameterized(Matcher.class, null, new Type[]{Types.wildcard()}), elementComputations);
    }
}

