/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import net.amygdalum.testrecorder.Wrapped;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedEnum;

public class DefaultEnumAdaptor
extends DefaultAdaptor<SerializedEnum, ObjectToSetupCode>
implements Adaptor<SerializedEnum, ObjectToSetupCode> {
    @Override
    public boolean matches(Type type) {
        return Types.baseType(type).isEnum();
    }

    @Override
    public Computation tryDeserialize(SerializedEnum value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerType(value.getType());
        if (Types.isHidden(value.getType())) {
            String typeName = types.getBestName(value.getType());
            String typeArgument = Templates.asLiteral(typeName);
            String wrapped = Templates.newObject(types.getRawName((Type)((Object)Wrapped.class)), typeArgument);
            return new Computation(wrapped);
        }
        String typeName = types.getBestName(value.getType());
        String name = value.getName();
        String enumConstant = Templates.fieldAccess(typeName, name);
        return new Computation(enumConstant);
    }
}

