/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.DefaultAdaptor;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.values.SerializedArray;

public class DefaultArrayAdaptor
extends DefaultAdaptor<SerializedArray, ObjectToSetupCode>
implements Adaptor<SerializedArray, ObjectToSetupCode> {
    @Override
    public Computation tryDeserialize(SerializedArray value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerType(value.getResultType());
        List elementTemplates = Stream.of(value.getArray()).map(element -> element.accept(generator)).collect(Collectors.toList());
        List<String> elements = elementTemplates.stream().map(template -> template.getValue()).collect(Collectors.toList());
        List<String> statements = elementTemplates.stream().flatMap(template -> template.getStatements().stream()).collect(Collectors.toList());
        String arrayLiteral = Templates.arrayLiteral(types.getSimpleName(value.getResultType()), elements);
        String name = generator.localVariable(value, value.getResultType());
        statements.add(Templates.assignLocalVariableStatement(types.getSimpleName(value.getResultType()), name, arrayLiteral));
        return new Computation(name, statements);
    }
}

