/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.testrecorder.DeserializationException;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedList;

public class CollectionsListAdaptor
implements Adaptor<SerializedList, ObjectToSetupCode> {
    private DefaultListAdaptor adaptor = new DefaultListAdaptor();

    @Override
    public Class<? extends Adaptor<SerializedList, ObjectToSetupCode>> parent() {
        return DefaultListAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return TypeSelector.innerClasses(Collections.class).filter(TypeSelector.startingWith("Unmodifiable", "Synchronized", "Checked", "Empty", "Singleton")).filter(element -> List.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalTypes(element, type));
    }

    @Override
    public Computation tryDeserialize(SerializedList value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.registerImport(List.class);
        String name = types.getSimpleName(value.getType());
        if (name.contains("Empty")) {
            return this.tryDeserializeEmpty(value, generator);
        }
        if (name.contains("Singleton")) {
            return this.tryDeserializeSingleton(value, generator);
        }
        if (name.contains("Unmodifiable")) {
            return this.tryDeserializeUnmodifiable(value, generator);
        }
        if (name.contains("Synchronized")) {
            return this.tryDeserializeSynchronized(value, generator);
        }
        if (name.contains("Checked")) {
            return this.tryDeserializeChecked(value, generator);
        }
        throw new DeserializationException(value.toString());
    }

    private Computation createOrdinaryList(SerializedList value, ObjectToSetupCode generator) {
        SerializedList baseValue = new SerializedList(Types.parameterized(ArrayList.class, null, new Type[]{value.getComponentType()}));
        baseValue.addAll(value);
        return this.adaptor.tryDeserialize(baseValue, generator);
    }

    private Computation tryDeserializeEmpty(SerializedList value, ObjectToSetupCode generator) {
        String factoryMethod = "emptyList";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Type resultType = Types.parameterized(List.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, new String[0]));
        return new Computation(resultList, Arrays.asList(decoratingStatement));
    }

    private Computation tryDeserializeSingleton(SerializedList value, ObjectToSetupCode generator) {
        String factoryMethod = "singletonList";
        TypeManager types = generator.getTypes();
        types.registerImport(List.class);
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = value.get(0).accept(generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(List.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeUnmodifiable(SerializedList value, ObjectToSetupCode generator) {
        String factoryMethod = "unmodifiableList";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinaryList(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(List.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeSynchronized(SerializedList value, ObjectToSetupCode generator) {
        String factoryMethod = "synchronizedList";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinaryList(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        Type resultType = Types.parameterized(List.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }

    private Computation tryDeserializeChecked(SerializedList value, ObjectToSetupCode generator) {
        String factoryMethod = "checkedList";
        TypeManager types = generator.getTypes();
        types.staticImport(Collections.class, factoryMethod);
        Computation computation = this.createOrdinaryList(value, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultBase = computation.getValue();
        String checkedType = types.getRawTypeName(value.getComponentType());
        Type resultType = Types.parameterized(List.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String decoratingStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod(factoryMethod, resultBase, checkedType));
        statements.add(decoratingStatement);
        return new Computation(resultList, statements);
    }
}

