/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers.builder;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.TypeSelector;
import net.amygdalum.testrecorder.deserializers.Adaptor;
import net.amygdalum.testrecorder.deserializers.Computation;
import net.amygdalum.testrecorder.deserializers.Templates;
import net.amygdalum.testrecorder.deserializers.TypeManager;
import net.amygdalum.testrecorder.deserializers.builder.DefaultArrayAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.DefaultListAdaptor;
import net.amygdalum.testrecorder.deserializers.builder.ObjectToSetupCode;
import net.amygdalum.testrecorder.util.Types;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedList;

public class ArraysListAdaptor
implements Adaptor<SerializedList, ObjectToSetupCode> {
    private DefaultArrayAdaptor adaptor = new DefaultArrayAdaptor();

    @Override
    public Class<? extends Adaptor<SerializedList, ObjectToSetupCode>> parent() {
        return DefaultListAdaptor.class;
    }

    @Override
    public boolean matches(Type type) {
        return TypeSelector.innerClasses(Arrays.class).filter(TypeSelector.in("ArrayList")).filter(element -> List.class.isAssignableFrom((Class<?>)element)).anyMatch(element -> Types.equalTypes(element, type));
    }

    @Override
    public Computation tryDeserialize(SerializedList value, ObjectToSetupCode generator) {
        TypeManager types = generator.getTypes();
        types.staticImport(Arrays.class, "asList");
        Type type = Types.array(value.getComponentType());
        SerializedArray baseValue = new SerializedArray(type);
        for (SerializedValue element : value) {
            baseValue.add(element);
        }
        Computation computation = this.adaptor.tryDeserialize(baseValue, generator);
        LinkedList<String> statements = new LinkedList<String>(computation.getStatements());
        String resultArray = computation.getValue();
        Type resultType = Types.parameterized(List.class, null, new Type[]{value.getComponentType()});
        String resultList = generator.localVariable(value, resultType);
        String asListStatement = Templates.assignLocalVariableStatement(types.getBestName(resultType), resultList, Templates.callLocalMethod("asList", resultArray));
        statements.add(asListStatement);
        return new Computation(resultList, statements);
    }
}

