/*
 * Decompiled with CFR 0.152.
 */
package net.amygdalum.testrecorder.deserializers;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.amygdalum.testrecorder.Deserializer;
import net.amygdalum.testrecorder.SerializedImmutableType;
import net.amygdalum.testrecorder.SerializedReferenceType;
import net.amygdalum.testrecorder.SerializedValue;
import net.amygdalum.testrecorder.SerializedValueType;
import net.amygdalum.testrecorder.values.SerializedArray;
import net.amygdalum.testrecorder.values.SerializedEnum;
import net.amygdalum.testrecorder.values.SerializedField;
import net.amygdalum.testrecorder.values.SerializedImmutable;
import net.amygdalum.testrecorder.values.SerializedList;
import net.amygdalum.testrecorder.values.SerializedMap;
import net.amygdalum.testrecorder.values.SerializedNull;
import net.amygdalum.testrecorder.values.SerializedObject;
import net.amygdalum.testrecorder.values.SerializedSet;

public class ValuePrinter
implements Deserializer<String> {
    private Set<Object> known = new LinkedHashSet<Object>();

    @Override
    public String visitField(SerializedField field) {
        return field.getType().getTypeName() + " " + field.getName() + ": " + field.getValue().accept(this);
    }

    @Override
    public String visitReferenceType(SerializedReferenceType rt) {
        if (rt instanceof SerializedObject) {
            SerializedObject value = (SerializedObject)rt;
            boolean inserted = this.known.add(value);
            if (inserted) {
                return value.getType().getTypeName() + "/" + System.identityHashCode(value) + " " + value.getFields().stream().sorted().map(field -> field.accept(this)).collect(Collectors.joining(",\n", "{\n", "\n}"));
            }
            return value.getType() + "/" + System.identityHashCode(value);
        }
        if (rt instanceof SerializedList) {
            SerializedList value = (SerializedList)rt;
            return value.stream().map(element -> element.accept(this)).collect(Collectors.joining(", ", "[", "]"));
        }
        if (rt instanceof SerializedMap) {
            SerializedMap value = (SerializedMap)rt;
            return value.entrySet().stream().map(element -> ((SerializedValue)element.getKey()).accept(this) + ":" + ((SerializedValue)element.getValue()).accept(this)).collect(Collectors.joining(",", "{", "}"));
        }
        if (rt instanceof SerializedSet) {
            SerializedSet value = (SerializedSet)rt;
            return value.stream().map(element -> element.accept(this)).collect(Collectors.joining(", ", "{", "}"));
        }
        if (rt instanceof SerializedArray) {
            SerializedArray value = (SerializedArray)rt;
            return Stream.of(value.getArray()).map(element -> element.accept(this)).collect(Collectors.joining(", ", "<", ">"));
        }
        if (rt instanceof SerializedNull) {
            return "null";
        }
        return "";
    }

    @Override
    public String visitImmutableType(SerializedImmutableType rt) {
        if (rt instanceof SerializedImmutable) {
            SerializedImmutable value = (SerializedImmutable)rt;
            return value.getValue().toString();
        }
        if (rt instanceof SerializedEnum) {
            SerializedEnum value = (SerializedEnum)rt;
            return value.getName();
        }
        return "";
    }

    @Override
    public String visitValueType(SerializedValueType value) {
        return value.getValue().toString();
    }
}

